/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP192K1Field {
    static final int[] a = new int[]{-4553, -2, -1, -1, -1, -1};
    private static final int[] b = new int[]{20729809, 9106, 1, 0, 0, 0, -9106, -3, -1, -1, -1, -1};
    private static final int[] c = new int[]{-20729809, -9107, -2, -1, -1, -1, 9105, 2};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat192.add(x, y, z);
        if (n2 != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            Nat.add33To(6, 4553, z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(12, xx, yy, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(6, x, z);
        if (n2 != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            Nat.add33To(6, 4553, z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat192.fromBigInteger(x);
        if (nArray[5] == -1 && Nat192.gte(nArray, a)) {
            Nat192.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(6, x, 0, z);
        } else {
            int n2 = Nat192.add(x, a, z);
            Nat.shiftDownBit(6, z, n2);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat192.createExt();
        Nat192.mul(x, y, nArray);
        SecP192K1Field.reduce(nArray, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        int n2 = Nat192.mulAddTo(x, y, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP192K1Field.isZero(x)) {
            Nat192.sub(a, a, z);
        } else {
            Nat192.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[24];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 6);
        } while (0 == Nat.lessThan(6, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SecP192K1Field.random(r2, z);
        } while (0 != SecP192K1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        long l2 = Nat192.mul33Add(4553, xx, 6, xx, 0, z, 0);
        int n2 = Nat192.mul33DWordAdd(4553, l2, z, 0);
        if (n2 != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            Nat.add33To(6, 4553, z);
        }
    }

    public static void reduce32(int x, int[] z) {
        if (x != 0 && Nat192.mul33WordAdd(4553, x, z, 0) != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            Nat.add33To(6, 4553, z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x, nArray);
        SecP192K1Field.reduce(nArray, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x, nArray);
        SecP192K1Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat192.square(z, nArray);
            SecP192K1Field.reduce(nArray, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat192.sub(x, y, z);
        if (n2 != 0) {
            Nat.sub33From(6, 4553, z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(12, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(12, zz, c.length);
        }
    }

    public static void twice(int[] x, int[] z) {
        int n2 = Nat.shiftUpBit(6, x, 0, z);
        if (n2 != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            Nat.add33To(6, 4553, z);
        }
    }
}

