/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP192R1Field;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP192R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF"));
    protected int[] x;

    public SecP192R1FieldElement(BigInteger x) {
        if (x == null || x.signum() < 0 || x.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP192R1FieldElement");
        }
        this.x = SecP192R1Field.fromBigInteger(x);
    }

    public SecP192R1FieldElement() {
        this.x = Nat192.create();
    }

    protected SecP192R1FieldElement(int[] x) {
        this.x = x;
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat192.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP192R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement b2) {
        int[] nArray = Nat192.create();
        SecP192R1Field.add(this.x, ((SecP192R1FieldElement)b2).x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat192.create();
        SecP192R1Field.addOne(this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement b2) {
        int[] nArray = Nat192.create();
        SecP192R1Field.subtract(this.x, ((SecP192R1FieldElement)b2).x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement b2) {
        int[] nArray = Nat192.create();
        SecP192R1Field.multiply(this.x, ((SecP192R1FieldElement)b2).x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement b2) {
        int[] nArray = Nat192.create();
        SecP192R1Field.inv(((SecP192R1FieldElement)b2).x, nArray);
        SecP192R1Field.multiply(nArray, this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat192.create();
        SecP192R1Field.negate(this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat192.create();
        SecP192R1Field.square(this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat192.create();
        SecP192R1Field.inv(this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat192.isZero(nArray) || Nat192.isOne(nArray)) {
            return this;
        }
        int[] nArray2 = Nat192.create();
        int[] nArray3 = Nat192.create();
        SecP192R1Field.square(nArray, nArray2);
        SecP192R1Field.multiply(nArray2, nArray, nArray2);
        SecP192R1Field.squareN(nArray2, 2, nArray3);
        SecP192R1Field.multiply(nArray3, nArray2, nArray3);
        SecP192R1Field.squareN(nArray3, 4, nArray2);
        SecP192R1Field.multiply(nArray2, nArray3, nArray2);
        SecP192R1Field.squareN(nArray2, 8, nArray3);
        SecP192R1Field.multiply(nArray3, nArray2, nArray3);
        SecP192R1Field.squareN(nArray3, 16, nArray2);
        SecP192R1Field.multiply(nArray2, nArray3, nArray2);
        SecP192R1Field.squareN(nArray2, 32, nArray3);
        SecP192R1Field.multiply(nArray3, nArray2, nArray3);
        SecP192R1Field.squareN(nArray3, 64, nArray2);
        SecP192R1Field.multiply(nArray2, nArray3, nArray2);
        SecP192R1Field.squareN(nArray2, 62, nArray2);
        SecP192R1Field.square(nArray2, nArray3);
        return Nat192.eq(nArray, nArray3) ? new SecP192R1FieldElement(nArray2) : null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecP192R1FieldElement)) {
            return false;
        }
        SecP192R1FieldElement secP192R1FieldElement = (SecP192R1FieldElement)other;
        return Nat192.eq(this.x, secP192R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 6);
    }
}

