/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat512;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP521R1Field {
    static final int[] a = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat.add(16, x, y, z) + x[16] + y[16];
        if (n2 > 511 || n2 == 511 && Nat.eq(16, z, a)) {
            n2 += Nat.inc(16, z);
            n2 &= 0x1FF;
        }
        z[16] = n2;
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(16, x, z) + x[16];
        if (n2 > 511 || n2 == 511 && Nat.eq(16, z, a)) {
            n2 += Nat.inc(16, z);
            n2 &= 0x1FF;
        }
        z[16] = n2;
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat.fromBigInteger(521, x);
        if (Nat.eq(17, nArray, a)) {
            Nat.zero(17, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        int n2 = x[16];
        int n3 = Nat.shiftDownBit(16, x, n2, z);
        z[16] = n2 >>> 1 | n3 >>> 23;
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 17; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat.create(33);
        SecP521R1Field.implMultiply(x, y, nArray);
        SecP521R1Field.reduce(nArray, z);
    }

    public static void multiply(int[] x, int[] y, int[] z, int[] tt) {
        SecP521R1Field.implMultiply(x, y, tt);
        SecP521R1Field.reduce(tt, z);
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP521R1Field.isZero(x)) {
            Nat.sub(17, a, a, z);
        } else {
            Nat.sub(17, a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[68];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 17);
            z[16] = z[16] & 0x1FF;
        } while (0 == Nat.lessThan(17, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SecP521R1Field.random(r2, z);
        } while (0 != SecP521R1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        int n2 = xx[32];
        int n3 = Nat.shiftDownBits(16, xx, 16, 9, n2, z, 0) >>> 23;
        n3 += n2 >>> 9;
        if ((n3 += Nat.addTo(16, xx, z)) > 511 || n3 == 511 && Nat.eq(16, z, a)) {
            n3 += Nat.inc(16, z);
            n3 &= 0x1FF;
        }
        z[16] = n3;
    }

    public static void reduce23(int[] z) {
        int n2 = z[16];
        int n3 = Nat.addWordTo(16, n2 >>> 9, z) + (n2 & 0x1FF);
        if (n3 > 511 || n3 == 511 && Nat.eq(16, z, a)) {
            n3 += Nat.inc(16, z);
            n3 &= 0x1FF;
        }
        z[16] = n3;
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat.create(33);
        SecP521R1Field.implSquare(x, nArray);
        SecP521R1Field.reduce(nArray, z);
    }

    public static void square(int[] x, int[] z, int[] tt) {
        SecP521R1Field.implSquare(x, tt);
        SecP521R1Field.reduce(tt, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat.create(33);
        SecP521R1Field.implSquare(x, nArray);
        SecP521R1Field.reduce(nArray, z);
        while (--n2 > 0) {
            SecP521R1Field.implSquare(z, nArray);
            SecP521R1Field.reduce(nArray, z);
        }
    }

    public static void squareN(int[] x, int n2, int[] z, int[] tt) {
        SecP521R1Field.implSquare(x, tt);
        SecP521R1Field.reduce(tt, z);
        while (--n2 > 0) {
            SecP521R1Field.implSquare(z, tt);
            SecP521R1Field.reduce(tt, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat.sub(16, x, y, z) + x[16] - y[16];
        if (n2 < 0) {
            n2 += Nat.dec(16, z);
            n2 &= 0x1FF;
        }
        z[16] = n2;
    }

    public static void twice(int[] x, int[] z) {
        int n2 = x[16];
        int n3 = Nat.shiftUpBit(16, x, n2 << 23, z) | n2 << 1;
        z[16] = n3 & 0x1FF;
    }

    protected static void implMultiply(int[] x, int[] y, int[] zz) {
        Nat512.mul(x, y, zz);
        int n2 = x[16];
        int n3 = y[16];
        zz[32] = Nat.mul31BothAdd(16, n2, y, n3, x, zz, 16) + n2 * n3;
    }

    protected static void implSquare(int[] x, int[] zz) {
        Nat512.square(x, zz);
        int n2 = x[16];
        zz[32] = Nat.mulWordAddTo(16, n2 << 1, x, 0, zz, 16) + n2 * n2;
    }
}

