/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.rfc8032;

import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.SHAKEDigest;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X448;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X448Field;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.e;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import java.security.SecureRandom;

public abstract class Ed448 {
    public static final int PREHASH_SIZE = 64;
    public static final int PUBLIC_KEY_SIZE = 57;
    public static final int SECRET_KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private static final byte[] a = new byte[]{83, 105, 103, 69, 100, 52, 52, 56};
    private static final int[] b = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] c = new int[]{118276190, 40534716, 9670182, 135141552, 85017403, 259173222, 68333082, 171784774, 174973732, 15824510, 73756743, 57518561, 94773951, 248652241, 107736333, 82941708};
    private static final int[] d = new int[]{36764180, 8885695, 130592152, 20104429, 163904957, 30304195, 121295871, 5901357, 125344798, 171541512, 175338348, 209069246, 3626697, 38307682, 24032956, 110359655};
    private static final int[] e = new int[]{110141154, 30892124, 160820362, 264558960, 217232225, 47722141, 19029845, 8326902, 183409749, 170134547, 90340180, 222600478, 61097333, 7431335, 198491505, 102372861};
    private static final int[] f = new int[]{221945828, 50763449, 132637478, 109250759, 216053960, 61612587, 50649998, 138339097, 98949899, 248139835, 186410297, 126520782, 47339196, 78164062, 198835543, 169622712};
    private static final Object g = new Object();
    private static b[] h = null;
    private static b[] i = null;
    private static int[] j = null;

    private static byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[28];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray, nArray);
        int[] nArray2 = new int[14];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray2, nArray2);
        int[] nArray3 = new int[14];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray3, nArray3);
        Nat.mulAddTo(14, nArray2, nArray3, nArray);
        byte[] byArray4 = new byte[114];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.a.a(nArray, 0, nArray.length, byArray4, 0);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray4);
    }

    private static boolean a(byte[] byArray) {
        return byArray != null && byArray.length < 256;
    }

    private static int a(b b2) {
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] nArray3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(b2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(b2.b, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray2, nArray3, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray2, nArray3, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray, 39081, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.subOne(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray, nArray2, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(nArray3);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZero(nArray) & ~com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZero(nArray3);
    }

    private static int a(c c2) {
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] nArray3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] nArray4 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.b, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.c, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray2, nArray3, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray2, nArray3, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray2, nArray4, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(nArray4, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray, 39081, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray, nArray4, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray, nArray2, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(nArray4);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZero(nArray) & ~com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZero(nArray3) & ~com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZero(nArray4);
    }

    private static boolean b(byte[] byArray) {
        int n2;
        int n3;
        if ((byArray[56] & 0x7F) != 0) {
            return false;
        }
        int n4 = n3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, 52);
        int n5 = n3 ^ b[13];
        for (n2 = 12; n2 > 0; --n2) {
            int n6 = com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, n2 * 4);
            if (n5 == 0 && n6 + Integer.MIN_VALUE > b[n2] + Integer.MIN_VALUE) {
                return false;
            }
            n4 |= n6;
            n5 |= n6 ^ b[n2];
        }
        n2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, 0);
        if (n4 == 0 && n2 + Integer.MIN_VALUE <= -2147483647) {
            return false;
        }
        return n5 != 0 || n2 + Integer.MIN_VALUE < b[0] - 1 + Integer.MIN_VALUE;
    }

    private static boolean b(b b2) {
        c c2 = new c();
        Ed448.b(b2, c2);
        return Ed448.b(c2);
    }

    private static boolean c(byte[] byArray) {
        if ((byArray[56] & 0x7F) != 0) {
            return false;
        }
        if (com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, 52) != b[13]) {
            return true;
        }
        int[] nArray = new int[14];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.a.a(byArray, 0, nArray, 0, 14);
        return !Nat.gte(14, nArray, b);
    }

    private static byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static Xof createPrehash() {
        return Ed448.a();
    }

    private static Xof a() {
        return new SHAKEDigest(256);
    }

    private static boolean a(byte[] byArray, boolean bl, b b2) {
        int n2 = (byArray[56] & 0x80) >>> 7;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.decode(byArray, b2.b);
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(b2.b, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray, 39081, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.negate(nArray, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.addOne(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.addOne(nArray2);
        if (!com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqrtRatioVar(nArray, nArray2, b2.a)) {
            return false;
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b2.a);
        if (n2 == 1 && com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZeroVar(b2.a)) {
            return false;
        }
        if (bl ^ n2 != (b2.a[0] & 1)) {
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.negate(b2.a, b2.a);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b2.a);
        }
        return true;
    }

    private static void a(Xof xof, byte by, byte[] byArray) {
        int n2 = a.length;
        byte[] byArray2 = new byte[n2 + 2 + byArray.length];
        System.arraycopy(a, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        byArray2[n2 + 1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, n2 + 2, byArray.length);
        xof.update(byArray2, 0, byArray2.length);
    }

    private static void a(b b2, byte[] byArray, int n2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.encode(b2.b, byArray, n2);
        byArray[n2 + 57 - 1] = (byte)((b2.a[0] & 1) << 7);
    }

    public static void encodePublicPoint(PublicPoint publicPoint, byte[] pk, int pkOff) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.encode(publicPoint.a, 16, pk, pkOff);
        pk[pkOff + 57 - 1] = (byte)((publicPoint.a[0] & 1) << 7);
    }

    private static int a(c c2, byte[] byArray, int n2) {
        b b2 = new b();
        Ed448.a(c2, b2);
        int n3 = Ed448.a(b2);
        Ed448.a(b2, byArray, n2);
        return n3;
    }

    private static PublicPoint c(b b2) {
        int[] nArray = new int[32];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(b2.a, 0, nArray, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(b2.b, 0, nArray, 16);
        return new PublicPoint(nArray);
    }

    public static void generatePrivateKey(SecureRandom random, byte[] k2) {
        if (k2.length != 57) {
            throw new IllegalArgumentException("k");
        }
        random.nextBytes(k2);
    }

    public static void generatePublicKey(byte[] sk, int skOff, byte[] pk, int pkOff) {
        Xof xof = Ed448.a();
        byte[] byArray = new byte[114];
        xof.update(sk, skOff, 57);
        xof.doFinal(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[57];
        Ed448.a(byArray, 0, byArray2);
        Ed448.a(byArray2, pk, pkOff);
    }

    public static PublicPoint generatePublicKey(byte[] sk, int skOff) {
        Xof xof = Ed448.a();
        byte[] byArray = new byte[114];
        xof.update(sk, skOff, 57);
        xof.doFinal(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[57];
        Ed448.a(byArray, 0, byArray2);
        c c2 = new c();
        Ed448.a(byArray2, c2);
        b b2 = new b();
        Ed448.a(c2, b2);
        if (0 == Ed448.a(b2)) {
            throw new IllegalStateException();
        }
        return Ed448.c(b2);
    }

    private static void a(Xof xof, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, byte[] byArray4, byte by, byte[] byArray5, int n3, int n4, byte[] byArray6, int n5) {
        Ed448.a(xof, by, byArray4);
        xof.update(byArray, 57, 57);
        xof.update(byArray5, n3, n4);
        xof.doFinal(byArray, 0, byArray.length);
        byte[] byArray7 = com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray);
        byte[] byArray8 = new byte[57];
        Ed448.a(byArray7, byArray8, 0);
        Ed448.a(xof, by, byArray4);
        xof.update(byArray8, 0, 57);
        xof.update(byArray3, n2, 57);
        xof.update(byArray5, n3, n4);
        xof.doFinal(byArray, 0, byArray.length);
        byte[] byArray9 = com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray);
        byte[] byArray10 = Ed448.a(byArray7, byArray9, byArray2);
        System.arraycopy(byArray8, 0, byArray6, n5, 57);
        System.arraycopy(byArray10, 0, byArray6, n5 + 57, 57);
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2, byte by, byte[] byArray3, int n3, int n4, byte[] byArray4, int n5) {
        if (!Ed448.a(byArray2)) {
            throw new IllegalArgumentException("ctx");
        }
        Xof xof = Ed448.a();
        byte[] byArray5 = new byte[114];
        xof.update(byArray, n2, 57);
        xof.doFinal(byArray5, 0, byArray5.length);
        byte[] byArray6 = new byte[57];
        Ed448.a(byArray5, 0, byArray6);
        byte[] byArray7 = new byte[57];
        Ed448.a(byArray6, byArray7, 0);
        Ed448.a(xof, byArray5, byArray6, byArray7, 0, byArray2, by, byArray3, n3, n4, byArray4, n5);
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, byte by, byte[] byArray4, int n4, int n5, byte[] byArray5, int n6) {
        if (!Ed448.a(byArray3)) {
            throw new IllegalArgumentException("ctx");
        }
        Xof xof = Ed448.a();
        byte[] byArray6 = new byte[114];
        xof.update(byArray, n2, 57);
        xof.doFinal(byArray6, 0, byArray6.length);
        byte[] byArray7 = new byte[57];
        Ed448.a(byArray6, 0, byArray7);
        Ed448.a(xof, byArray6, byArray7, byArray2, n3, byArray3, by, byArray4, n4, n5, byArray5, n6);
    }

    private static boolean a(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, byte by, byte[] byArray4, int n4, int n5) {
        if (!Ed448.a(byArray3)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray5 = Ed448.a(byArray, n2, 57);
        byte[] byArray6 = Ed448.a(byArray, n2 + 57, 57);
        byte[] byArray7 = Ed448.a(byArray2, n3, 57);
        if (!Ed448.c(byArray5)) {
            return false;
        }
        int[] nArray = new int[14];
        if (!com.enterprisedt.bouncycastle.math.ec.rfc8032.c.a(byArray6, nArray)) {
            return false;
        }
        if (!Ed448.b(byArray7)) {
            return false;
        }
        b b2 = new b();
        if (!Ed448.a(byArray5, true, b2)) {
            return false;
        }
        b b3 = new b();
        if (!Ed448.a(byArray7, true, b3)) {
            return false;
        }
        Xof xof = Ed448.a();
        byte[] byArray8 = new byte[114];
        Ed448.a(xof, by, byArray3);
        xof.update(byArray5, 0, 57);
        xof.update(byArray7, 0, 57);
        xof.update(byArray4, n4, n5);
        xof.doFinal(byArray8, 0, byArray8.length);
        byte[] byArray9 = com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray8);
        int[] nArray2 = new int[14];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray9, nArray2);
        int[] nArray3 = new int[8];
        int[] nArray4 = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(nArray2, nArray3, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.a(nArray, nArray4, nArray);
        c c2 = new c();
        Ed448.a(nArray, nArray3, b3, nArray4, b2, c2);
        return Ed448.b(c2);
    }

    private static boolean a(byte[] byArray, int n2, PublicPoint publicPoint, byte[] byArray2, byte by, byte[] byArray3, int n3, int n4) {
        if (!Ed448.a(byArray2)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray4 = Ed448.a(byArray, n2, 57);
        byte[] byArray5 = Ed448.a(byArray, n2 + 57, 57);
        if (!Ed448.c(byArray4)) {
            return false;
        }
        int[] nArray = new int[14];
        if (!com.enterprisedt.bouncycastle.math.ec.rfc8032.c.a(byArray5, nArray)) {
            return false;
        }
        b b2 = new b();
        if (!Ed448.a(byArray4, true, b2)) {
            return false;
        }
        b b3 = new b();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.negate(publicPoint.a, b3.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(publicPoint.a, 16, b3.b, 0);
        byte[] byArray6 = new byte[57];
        Ed448.encodePublicPoint(publicPoint, byArray6, 0);
        Xof xof = Ed448.a();
        byte[] byArray7 = new byte[114];
        Ed448.a(xof, by, byArray2);
        xof.update(byArray4, 0, 57);
        xof.update(byArray6, 0, 57);
        xof.update(byArray3, n3, n4);
        xof.doFinal(byArray7, 0, byArray7.length);
        byte[] byArray8 = com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray7);
        int[] nArray2 = new int[14];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray8, nArray2);
        int[] nArray3 = new int[8];
        int[] nArray4 = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(nArray2, nArray3, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.a(nArray, nArray4, nArray);
        c c2 = new c();
        Ed448.a(nArray, nArray3, b3, nArray4, b2, c2);
        return Ed448.b(c2);
    }

    private static void a(c[] cArray) {
        int n2 = cArray.length;
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.createTable(n2);
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(cArray[0].c, 0, nArray2, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(nArray2, 0, nArray, 0);
        int n3 = 0;
        while (++n3 < n2) {
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray2, cArray[n3].c, nArray2);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(nArray2, 0, nArray, n3 * 16);
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.invVar(nArray2, nArray2);
        --n3;
        int[] nArray3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        while (n3 > 0) {
            int n4 = n3--;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(nArray, n3 * 16, nArray3, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray3, nArray2, nArray3);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray2, cArray[n4].c, nArray2);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(nArray3, 0, cArray[n4].c, 0);
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(nArray2, 0, cArray[0].c, 0);
    }

    private static void a(c c2, b b2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.inv(c2.c, b2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(b2.b, c2.a, b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(b2.b, c2.b, b2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b2.b);
    }

    private static boolean b(c c2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(c2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(c2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(c2.c);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZeroVar(c2.a) && !com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.isZeroVar(c2.b) && com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.areEqualVar(c2.b, c2.c);
    }

    private static void a(b b2, c c2, d d2) {
        int[] nArray = d2.b;
        int[] nArray2 = d2.c;
        int[] nArray3 = d2.d;
        int[] nArray4 = d2.e;
        int[] nArray5 = d2.f;
        int[] nArray6 = d2.g;
        int[] nArray7 = d2.h;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.c, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(b2.a, c2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(b2.b, c2.b, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray2, nArray3, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray4, 39081, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray, nArray4, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray, nArray4, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(b2.b, b2.a, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(c2.b, c2.a, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray7, nArray4, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray3, nArray2, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray3, nArray2, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.carry(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray7, nArray, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray7, c2.c, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray4, c2.c, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray5, nArray7, c2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray4, nArray6, c2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray5, nArray6, c2.c);
    }

    private static void a(c c2, c c3, d d2) {
        int[] nArray = d2.a;
        int[] nArray2 = d2.b;
        int[] nArray3 = d2.c;
        int[] nArray4 = d2.d;
        int[] nArray5 = d2.e;
        int[] nArray6 = d2.f;
        int[] nArray7 = d2.g;
        int[] nArray8 = d2.h;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.c, c3.c, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(nArray, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.a, c3.a, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.b, c3.b, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray3, nArray4, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray5, 39081, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray2, nArray5, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray2, nArray5, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(c2.b, c2.a, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(c3.b, c3.a, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray8, nArray5, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray4, nArray3, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray4, nArray3, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.carry(nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray8, nArray2, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray8, nArray, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray5, nArray, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray6, nArray8, c3.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray5, nArray7, c3.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray6, nArray7, c3.c);
    }

    private static void a(boolean bl, b b2, c c2, d d2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = d2.b;
        int[] nArray6 = d2.c;
        int[] nArray7 = d2.d;
        int[] nArray8 = d2.e;
        int[] nArray9 = d2.f;
        int[] nArray10 = d2.g;
        int[] nArray11 = d2.h;
        if (bl) {
            nArray4 = nArray8;
            nArray3 = nArray5;
            nArray2 = nArray10;
            nArray = nArray9;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(b2.b, b2.a, nArray11);
        } else {
            nArray4 = nArray5;
            nArray3 = nArray8;
            nArray2 = nArray9;
            nArray = nArray10;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(b2.b, b2.a, nArray11);
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.c, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(b2.a, c2.a, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(b2.b, c2.b, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray6, nArray7, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray8, 39081, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray5, nArray8, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray5, nArray8, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(c2.b, c2.a, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray11, nArray8, nArray11);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray7, nArray6, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray7, nArray6, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.carry(nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray11, nArray5, nArray11);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray11, c2.c, nArray11);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray8, c2.c, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray9, nArray11, c2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray8, nArray10, c2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray9, nArray10, c2.c);
    }

    private static void a(boolean bl, c c2, c c3, d d2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = d2.a;
        int[] nArray6 = d2.b;
        int[] nArray7 = d2.c;
        int[] nArray8 = d2.d;
        int[] nArray9 = d2.e;
        int[] nArray10 = d2.f;
        int[] nArray11 = d2.g;
        int[] nArray12 = d2.h;
        if (bl) {
            nArray4 = nArray9;
            nArray3 = nArray6;
            nArray2 = nArray11;
            nArray = nArray10;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(c2.b, c2.a, nArray12);
        } else {
            nArray4 = nArray6;
            nArray3 = nArray9;
            nArray2 = nArray10;
            nArray = nArray11;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(c2.b, c2.a, nArray12);
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.c, c3.c, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(nArray5, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.a, c3.a, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.b, c3.b, nArray8);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray7, nArray8, nArray9);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray9, 39081, nArray9);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray6, nArray9, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray6, nArray9, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(c3.b, c3.a, nArray9);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray12, nArray9, nArray12);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray8, nArray7, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray8, nArray7, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.carry(nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray12, nArray6, nArray12);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray12, nArray5, nArray12);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray9, nArray5, nArray9);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray10, nArray12, c3.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray9, nArray11, c3.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray10, nArray11, c3.c);
    }

    private static void a(b b2, c c2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(b2.a, 0, c2.a, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(b2.b, 0, c2.b, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.one(c2.c);
    }

    private static void a(c c2, c c3) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c2.a, 0, c3.a, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c2.b, 0, c3.b, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c2.c, 0, c3.c, 0);
    }

    private static void a(c c2, d d2) {
        int[] nArray = d2.b;
        int[] nArray2 = d2.c;
        int[] nArray3 = d2.d;
        int[] nArray4 = d2.e;
        int[] nArray5 = d2.h;
        int[] nArray6 = d2.a;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(c2.a, c2.b, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(nArray, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.b, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray2, nArray3, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.carry(nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sqr(c2.c, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.add(nArray5, nArray5, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.carry(nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray4, nArray5, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray, nArray4, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.sub(nArray2, nArray3, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray, nArray6, c2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray4, nArray2, c2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(nArray4, nArray6, c2.c);
    }

    private static void a(int n2, int n3, b b2) {
        int n4 = n2 * 16 * 2 * 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            int n5 = (i2 ^ n3) - 1 >> 31;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.cmov(n5, j, n4, b2.a, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.cmov(n5, j, n4 += 16, b2.b, 0);
            n4 += 16;
        }
    }

    private static void a(b b2, c[] cArray, int n2, int n3, d d2) {
        c c2 = new c();
        Ed448.a(b2, c2);
        Ed448.a(c2, d2);
        cArray[n2] = new c();
        Ed448.a(b2, cArray[n2]);
        for (int i2 = 1; i2 < n3; ++i2) {
            cArray[n2 + i2] = new c();
            Ed448.a(cArray[n2 + i2 - 1], cArray[n2 + i2]);
            Ed448.a(c2, cArray[n2 + i2], d2);
        }
    }

    private static void c(c c2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.zero(c2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.one(c2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.one(c2.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void precompute() {
        Object object = g;
        synchronized (object) {
            c c2;
            int n2;
            if (j != null) {
                return;
            }
            int n3 = 32;
            int n4 = 80;
            int n5 = n3 * 2 + n4;
            c[] cArray = new c[n5];
            d d2 = new d();
            b b2 = new b();
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c, 0, b2.a, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(d, 0, b2.b, 0);
            Ed448.a(b2, cArray, 0, n3, d2);
            b b3 = new b();
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(e, 0, b3.a, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(f, 0, b3.b, 0);
            Ed448.a(b3, cArray, n3, n3, d2);
            c c3 = new c();
            Ed448.a(b2, c3);
            int n6 = n3 * 2;
            c[] cArray2 = new c[5];
            for (n2 = 0; n2 < 5; ++n2) {
                cArray2[n2] = new c();
            }
            for (n2 = 0; n2 < 5; ++n2) {
                int n7;
                int n8;
                int n9 = n6++;
                c c4 = new c();
                cArray[n9] = c4;
                c2 = c4;
                for (n8 = 0; n8 < 5; ++n8) {
                    if (n8 == 0) {
                        Ed448.a(c3, c2);
                    } else {
                        Ed448.a(c3, c2, d2);
                    }
                    Ed448.a(c3, d2);
                    Ed448.a(c3, cArray2[n8]);
                    if (n2 + n8 == 8) continue;
                    for (n7 = 1; n7 < 18; ++n7) {
                        Ed448.a(c3, d2);
                    }
                }
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.negate(c2.a, c2.a);
                for (n8 = 0; n8 < 4; ++n8) {
                    n7 = 1 << n8;
                    int n10 = 0;
                    while (n10 < n7) {
                        cArray[n6] = new c();
                        Ed448.a(cArray[n6 - n7], cArray[n6]);
                        Ed448.a(cArray2[n8], cArray[n6], d2);
                        ++n10;
                        ++n6;
                    }
                }
            }
            Ed448.a(cArray);
            h = new b[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = cArray[n2];
                b b4 = Ed448.h[n2] = new b();
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.a, c2.c, b4.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b4.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.b, c2.c, b4.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b4.b);
            }
            i = new b[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = cArray[n3 + n2];
                b b5 = Ed448.i[n2] = new b();
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.a, c2.c, b5.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b5.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c2.b, c2.c, b5.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(b5.b);
            }
            j = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.createTable(n4 * 2);
            n2 = 0;
            for (int i2 = n3 * 2; i2 < n5; ++i2) {
                c c5 = cArray[i2];
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c5.a, c5.c, c5.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(c5.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.mul(c5.b, c5.c, c5.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.normalize(c5.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c5.a, 0, j, n2);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c5.b, 0, j, n2 += 16);
                n2 += 16;
            }
        }
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray, n2, byArray2, 0, 56);
        byArray2[0] = (byte)(byArray2[0] & 0xFC);
        byArray2[55] = (byte)(byArray2[55] | 0x80);
        byArray2[56] = 0;
    }

    private static void a(byte[] byArray, c c2) {
        Ed448.precompute();
        int[] nArray = new int[15];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.b(byArray, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.a(450, nArray, nArray);
        b b2 = new b();
        d d2 = new d();
        Ed448.c(c2);
        int n2 = 17;
        while (true) {
            int n3 = n2;
            for (int i2 = 0; i2 < 5; ++i2) {
                int n4;
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < 5; ++n5) {
                    n4 = nArray[n3 >>> 5] >>> (n3 & 0x1F);
                    n6 &= ~(1 << n5);
                    n6 ^= n4 << n5;
                    n3 += 18;
                }
                n5 = n6 >>> 4 & 1;
                n4 = (n6 ^ -n5) & 0xF;
                Ed448.a(i2, n4, b2);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.cnegate(n5, b2.a);
                Ed448.a(b2, c2, d2);
            }
            if (--n2 < 0) break;
            Ed448.a(c2, d2);
        }
    }

    private static void a(byte[] byArray, byte[] byArray2, int n2) {
        c c2 = new c();
        Ed448.a(byArray, c2);
        if (0 == Ed448.a(c2, byArray2, n2)) {
            throw new IllegalStateException();
        }
    }

    public static void scalarMultBaseXY(X448.Friend friend, byte[] k2, int kOff, int[] x, int[] y) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by X448");
        }
        byte[] byArray = new byte[57];
        Ed448.a(k2, kOff, byArray);
        c c2 = new c();
        Ed448.a(byArray, c2);
        if (0 == Ed448.a(c2)) {
            throw new IllegalStateException();
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c2.a, 0, x, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.copy(c2.b, 0, y, 0);
    }

    private static void b(b b2, c c2) {
        byte[] byArray = new byte[447];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.c.a(5, byArray);
        int n2 = 8;
        c[] cArray = new c[n2];
        d d2 = new d();
        Ed448.a(b2, cArray, 0, n2, d2);
        Ed448.c(c2);
        int n3 = 446;
        while (true) {
            byte by;
            if ((by = byArray[n3]) != 0) {
                int n4 = by >> 1 ^ by >> 31;
                Ed448.a(by < 0, cArray[n4], c2, d2);
            }
            if (--n3 < 0) break;
            Ed448.a(c2, d2);
        }
    }

    private static void a(int[] nArray, int[] nArray2, b b2, int[] nArray3, b b3, c c2) {
        Ed448.precompute();
        byte[] byArray = new byte[450];
        byte[] byArray2 = new byte[225];
        byte[] byArray3 = new byte[225];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.e.a(nArray, 7, byArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.e.a(nArray2, 5, byArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.e.a(nArray3, 5, byArray3);
        int n2 = 8;
        c[] cArray = new c[n2];
        c[] cArray2 = new c[n2];
        d d2 = new d();
        Ed448.a(b2, cArray, 0, n2, d2);
        Ed448.a(b3, cArray2, 0, n2, d2);
        Ed448.c(c2);
        int n3 = 225;
        while (--n3 >= 0 && (byArray[n3] | byArray[225 + n3] | byArray2[n3] | byArray3[n3]) == 0) {
        }
        while (n3 >= 0) {
            int n4;
            int n5;
            int n6;
            byte by = byArray[n3];
            if (by != 0) {
                n6 = by >> 1 ^ by >> 31;
                Ed448.a(by < 0, h[n6], c2, d2);
            }
            if ((n6 = byArray[225 + n3]) != 0) {
                n5 = n6 >> 1 ^ n6 >> 31;
                Ed448.a(n6 < 0, i[n5], c2, d2);
            }
            if ((n5 = byArray2[n3]) != 0) {
                n4 = n5 >> 1 ^ n5 >> 31;
                Ed448.a(n5 < 0, cArray[n4], c2, d2);
            }
            if ((n4 = byArray3[n3]) != 0) {
                int n7 = n4 >> 1 ^ n4 >> 31;
                Ed448.a(n4 < 0, cArray2[n7], c2, d2);
            }
            Ed448.a(c2, d2);
            --n3;
        }
        Ed448.a(c2, d2);
    }

    public static void sign(byte[] sk, int skOff, byte[] ctx, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        byte by = 0;
        Ed448.a(sk, skOff, ctx, by, m2, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        byte by = 0;
        Ed448.a(sk, skOff, pk, pkOff, ctx, by, m2, mOff, mLen, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte by = 1;
        Ed448.a(sk, skOff, ctx, by, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte by = 1;
        Ed448.a(sk, skOff, pk, pkOff, ctx, by, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, Xof ph, byte[] sig, int sigOff) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0, 64)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        Ed448.a(sk, skOff, ctx, by, byArray, 0, byArray.length, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, Xof ph, byte[] sig, int sigOff) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0, 64)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        Ed448.a(sk, skOff, pk, pkOff, ctx, by, byArray, 0, byArray.length, sig, sigOff);
    }

    public static boolean validatePublicKeyFull(byte[] pk, int pkOff) {
        byte[] byArray = Ed448.a(pk, pkOff, 57);
        if (!Ed448.b(byArray)) {
            return false;
        }
        b b2 = new b();
        if (!Ed448.a(byArray, false, b2)) {
            return false;
        }
        return Ed448.b(b2);
    }

    public static PublicPoint validatePublicKeyFullExport(byte[] pk, int pkOff) {
        byte[] byArray = Ed448.a(pk, pkOff, 57);
        if (!Ed448.b(byArray)) {
            return null;
        }
        b b2 = new b();
        if (!Ed448.a(byArray, false, b2)) {
            return null;
        }
        if (!Ed448.b(b2)) {
            return null;
        }
        return Ed448.c(b2);
    }

    public static boolean validatePublicKeyPartial(byte[] pk, int pkOff) {
        byte[] byArray = Ed448.a(pk, pkOff, 57);
        if (!Ed448.b(byArray)) {
            return false;
        }
        b b2 = new b();
        return Ed448.a(byArray, false, b2);
    }

    public static PublicPoint validatePublicKeyPartialExport(byte[] pk, int pkOff) {
        byte[] byArray = Ed448.a(pk, pkOff, 57);
        if (!Ed448.b(byArray)) {
            return null;
        }
        b b2 = new b();
        if (!Ed448.a(byArray, false, b2)) {
            return null;
        }
        return Ed448.c(b2);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] m2, int mOff, int mLen) {
        byte by = 0;
        return Ed448.a(sig, sigOff, pk, pkOff, ctx, by, m2, mOff, mLen);
    }

    public static boolean verify(byte[] sig, int sigOff, PublicPoint publicPoint, byte[] ctx, byte[] m2, int mOff, int mLen) {
        byte by = 0;
        return Ed448.a(sig, sigOff, publicPoint, ctx, by, m2, mOff, mLen);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff) {
        byte by = 1;
        return Ed448.a(sig, sigOff, pk, pkOff, ctx, by, ph, phOff, 64);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, PublicPoint publicPoint, byte[] ctx, byte[] ph, int phOff) {
        byte by = 1;
        return Ed448.a(sig, sigOff, publicPoint, ctx, by, ph, phOff, 64);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, Xof ph) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0, 64)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        return Ed448.a(sig, sigOff, pk, pkOff, ctx, by, byArray, 0, byArray.length);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, PublicPoint publicPoint, byte[] ctx, Xof ph) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0, 64)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        return Ed448.a(sig, sigOff, publicPoint, ctx, by, byArray, 0, byArray.length);
    }

    private static class d {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] c = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] d = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] e = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] f = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] g = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] h = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();

        private d() {
        }
    }

    private static class c {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] c = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();

        private c() {
        }
    }

    private static class b {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448$a.create();

        private b() {
        }
    }

    private static class a
    extends X448Field {
    }

    public static final class PublicPoint {
        final int[] a;

        PublicPoint(int[] data) {
            this.a = data;
        }
    }

    public static final class Algorithm {
        public static final int Ed448 = 0;
        public static final int Ed448ph = 1;
    }
}

