/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.tools;

import com.enterprisedt.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.enterprisedt.bouncycastle.crypto.ec.CustomNamedCurves;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class F2mSqrtOptimizer {
    public static void main(String[] args) {
        TreeSet treeSet = new TreeSet(F2mSqrtOptimizer.a(ECNamedCurveTable.getNames()));
        treeSet.addAll(F2mSqrtOptimizer.a(CustomNamedCurves.getNames()));
        for (String string : treeSet) {
            ECCurve eCCurve;
            X9ECParametersHolder x9ECParametersHolder = CustomNamedCurves.getByNameLazy(string);
            if (x9ECParametersHolder == null) {
                x9ECParametersHolder = ECNamedCurveTable.getByNameLazy(string);
            }
            if (x9ECParametersHolder == null || !ECAlgorithms.isF2mCurve(eCCurve = x9ECParametersHolder.getCurve())) continue;
            System.out.print(string + ":");
            F2mSqrtOptimizer.a(eCCurve);
        }
    }

    public static void printRootZ(ECCurve curve) {
        if (!ECAlgorithms.isF2mCurve(curve)) {
            throw new IllegalArgumentException("Sqrt optimization only defined over characteristic-2 fields");
        }
        F2mSqrtOptimizer.a(curve);
    }

    private static void a(ECCurve eCCurve) {
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(BigInteger.valueOf(2L));
        ECFieldElement eCFieldElement2 = eCFieldElement.sqrt();
        System.out.println(eCFieldElement2.toBigInteger().toString(16).toUpperCase());
        if (!eCFieldElement2.square().equals(eCFieldElement)) {
            throw new IllegalStateException("Optimized-sqrt sanity check failed");
        }
    }

    private static ArrayList a(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }
}

