/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat128 {
    public static int add(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addBothTo(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x, int xOff, int[] z, int zOff, int cIn) {
        long l2 = (long)cIn & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) + ((long)z[zOff + 3] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addToEachOther(int[] u2, int uOff, int[] v2, int vOff) {
        long l2 = 0L;
        u2[uOff + 0] = (int)(l2 += ((long)u2[uOff + 0] & 0xFFFFFFFFL) + ((long)v2[vOff + 0] & 0xFFFFFFFFL));
        v2[vOff + 0] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 1] = (int)(l2 += ((long)u2[uOff + 1] & 0xFFFFFFFFL) + ((long)v2[vOff + 1] & 0xFFFFFFFFL));
        v2[vOff + 1] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 2] = (int)(l2 += ((long)u2[uOff + 2] & 0xFFFFFFFFL) + ((long)v2[vOff + 2] & 0xFFFFFFFFL));
        v2[vOff + 2] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 3] = (int)(l2 += ((long)u2[uOff + 3] & 0xFFFFFFFFL) + ((long)v2[vOff + 3] & 0xFFFFFFFFL));
        v2[vOff + 3] = (int)l2;
        return (int)(l2 >>>= 32);
    }

    public static void copy(int[] x, int[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
    }

    public static void copy(int[] x, int xOff, int[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
        z[zOff + 2] = x[xOff + 2];
        z[zOff + 3] = x[xOff + 3];
    }

    public static void copy64(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
    }

    public static void copy64(long[] x, int xOff, long[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
    }

    public static int[] create() {
        return new int[4];
    }

    public static long[] create64() {
        return new long[2];
    }

    public static int[] createExt() {
        return new int[8];
    }

    public static long[] createExt64() {
        return new long[4];
    }

    public static boolean diff(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        boolean bl = Nat128.gte(x, xOff, y, yOff);
        if (bl) {
            Nat128.sub(x, xOff, y, yOff, z, zOff);
        } else {
            Nat128.sub(y, yOff, x, xOff, z, zOff);
        }
        return bl;
    }

    public static boolean eq(int[] x, int[] y) {
        for (int i2 = 3; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] x, long[] y) {
        for (int i2 = 1; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat128.create();
        for (int i2 = 0; i2 < 4; ++i2) {
            nArray[i2] = x.intValue();
            x = x.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat128.create64();
        for (int i2 = 0; i2 < 2; ++i2) {
            lArray[i2] = x.longValue();
            x = x.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] x, int bit) {
        if (bit == 0) {
            return x[0] & 1;
        }
        int n2 = bit >> 5;
        if (n2 < 0 || n2 >= 4) {
            return 0;
        }
        int n3 = bit & 0x1F;
        return x[n2] >>> n3 & 1;
    }

    public static boolean gte(int[] x, int[] y) {
        for (int i2 = 3; i2 >= 0; --i2) {
            int n2 = x[i2] ^ Integer.MIN_VALUE;
            int n3 = y[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] x, int xOff, int[] y, int yOff) {
        for (int i2 = 3; i2 >= 0; --i2) {
            int n2 = x[xOff + i2] ^ Integer.MIN_VALUE;
            int n3 = y[yOff + i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] x) {
        if (x[0] != 1) {
            return false;
        }
        for (int i2 = 1; i2 < 4; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] x) {
        if (x[0] != 1L) {
            return false;
        }
        for (int i2 = 1; i2 < 2; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] x) {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] x) {
        for (int i2 = 0; i2 < 2; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x, int[] y, int[] zz) {
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        long l3 = (long)y[1] & 0xFFFFFFFFL;
        long l4 = (long)y[2] & 0xFFFFFFFFL;
        long l5 = (long)y[3] & 0xFFFFFFFFL;
        long l6 = 0L;
        long l7 = (long)x[0] & 0xFFFFFFFFL;
        zz[0] = (int)(l6 += l7 * l2);
        l6 >>>= 32;
        zz[1] = (int)(l6 += l7 * l3);
        l6 >>>= 32;
        zz[2] = (int)(l6 += l7 * l4);
        l6 >>>= 32;
        zz[3] = (int)(l6 += l7 * l5);
        zz[4] = (int)(l6 >>>= 32);
        for (int i2 = 1; i2 < 4; ++i2) {
            long l8 = 0L;
            long l9 = (long)x[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l8 += l9 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 1] = (int)(l8 += l9 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 2] = (int)(l8 += l9 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[i2 + 3] = (int)(l8 += l9 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            zz[i2 + 4] = (int)(l8 >>>= 32);
        }
    }

    public static void mul(int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y[yOff + 3] & 0xFFFFFFFFL;
        long l6 = 0L;
        long l7 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l6 += l7 * l2);
        l6 >>>= 32;
        zz[zzOff + 1] = (int)(l6 += l7 * l3);
        l6 >>>= 32;
        zz[zzOff + 2] = (int)(l6 += l7 * l4);
        l6 >>>= 32;
        zz[zzOff + 3] = (int)(l6 += l7 * l5);
        zz[zzOff + 4] = (int)(l6 >>>= 32);
        for (int i2 = 1; i2 < 4; ++i2) {
            long l8 = 0L;
            long l9 = (long)x[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l8 += l9 * l2 + ((long)zz[++zzOff + 0] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 1] = (int)(l8 += l9 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 2] = (int)(l8 += l9 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l8 >>>= 32;
            zz[zzOff + 3] = (int)(l8 += l9 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            zz[zzOff + 4] = (int)(l8 >>>= 32);
        }
    }

    public static int mulAddTo(int[] x, int[] y, int[] zz) {
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        long l3 = (long)y[1] & 0xFFFFFFFFL;
        long l4 = (long)y[2] & 0xFFFFFFFFL;
        long l5 = (long)y[3] & 0xFFFFFFFFL;
        long l6 = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            long l7 = 0L;
            long l8 = (long)x[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l7 += l8 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l7 >>>= 32;
            zz[i2 + 1] = (int)(l7 += l8 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l7 >>>= 32;
            zz[i2 + 2] = (int)(l7 += l8 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l7 >>>= 32;
            zz[i2 + 3] = (int)(l7 += l8 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            zz[i2 + 4] = (int)(l6 += (l7 >>>= 32) + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l6 >>>= 32;
        }
        return (int)l6;
    }

    public static int mulAddTo(int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y[yOff + 3] & 0xFFFFFFFFL;
        long l6 = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            long l7 = 0L;
            long l8 = (long)x[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l7 += l8 * l2 + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
            l7 >>>= 32;
            zz[zzOff + 1] = (int)(l7 += l8 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l7 >>>= 32;
            zz[zzOff + 2] = (int)(l7 += l8 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l7 >>>= 32;
            zz[zzOff + 3] = (int)(l7 += l8 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            zz[zzOff + 4] = (int)(l6 += (l7 >>>= 32) + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l6 >>>= 32;
            ++zzOff;
        }
        return (int)l6;
    }

    public static long mul33Add(int w, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)w & 0xFFFFFFFFL;
        long l4 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * l4 + ((long)y[yOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = (long)x[xOff + 1] & 0xFFFFFFFFL;
        z[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)y[yOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l6 = (long)x[xOff + 2] & 0xFFFFFFFFL;
        z[zOff + 2] = (int)(l2 += l3 * l6 + l5 + ((long)y[yOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l7 = (long)x[xOff + 3] & 0xFFFFFFFFL;
        z[zOff + 3] = (int)(l2 += l3 * l7 + l6 + ((long)y[yOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        return l2 += l7;
    }

    public static int mulWordAddExt(int x, int[] yy, int yyOff, int[] zz, int zzOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l2 += l3 * ((long)yy[yyOff + 0] & 0xFFFFFFFFL) + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 1] = (int)(l2 += l3 * ((long)yy[yyOff + 1] & 0xFFFFFFFFL) + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 2] = (int)(l2 += l3 * ((long)yy[yyOff + 2] & 0xFFFFFFFFL) + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        zz[zzOff + 3] = (int)(l2 += l3 * ((long)yy[yyOff + 3] & 0xFFFFFFFFL) + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mul33DWordAdd(int x, long y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        long l4 = y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * l4 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = y >>> 32;
        z[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += l5 + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += (long)z[zOff + 3] & 0xFFFFFFFFL);
        return (int)(l2 >>>= 32);
    }

    public static int mul33WordAdd(int x, int y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        long l4 = (long)y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l4 * l3 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += l4 + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += (long)z[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(4, z, zOff, 3);
    }

    public static int mulWordDwordAdd(int x, long y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * (y & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += l3 * (y >>> 32) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += (long)z[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(4, z, zOff, 3);
    }

    public static int mulWordsAdd(int x, int y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        long l4 = (long)y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l4 * l3 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += (long)z[zOff + 1] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(4, z, zOff, 2);
    }

    public static int mulWord(int x, int[] y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[zOff + n2] = (int)(l2 += l3 * ((long)y[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < 4);
        return (int)l2;
    }

    public static void square(int[] x, int[] zz) {
        long l2;
        long l3;
        long l4 = (long)x[0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 3;
        int n4 = 8;
        do {
            l3 = (long)x[n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[--n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[--n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x[1] & 0xFFFFFFFFL;
        l3 = (long)zz[2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x[2] & 0xFFFFFFFFL;
        long l7 = (long)zz[3] & 0xFFFFFFFFL;
        long l8 = (long)zz[4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x[3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32;
        n5 = (int)l8;
        zz[4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)(l10 &= 0xFFFFFFFFL);
        zz[5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l11;
        zz[6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[7] + (int)(l11 >>> 32);
        zz[7] = n5 << 1 | n2;
    }

    public static void square(int[] x, int xOff, int[] zz, int zzOff) {
        long l2;
        long l3;
        long l4 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 3;
        int n4 = 8;
        do {
            l3 = (long)x[xOff + n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[zzOff + --n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[zzOff + --n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[zzOff + 0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x[xOff + 1] & 0xFFFFFFFFL;
        l3 = (long)zz[zzOff + 2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[zzOff + 1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x[xOff + 2] & 0xFFFFFFFFL;
        long l7 = (long)zz[zzOff + 3] & 0xFFFFFFFFL;
        long l8 = (long)zz[zzOff + 4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[zzOff + 2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x[xOff + 3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[zzOff + 5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[zzOff + 6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[zzOff + 3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32;
        n5 = (int)l8;
        zz[zzOff + 4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l10;
        zz[zzOff + 5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l11;
        zz[zzOff + 6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[zzOff + 7] + (int)(l11 >>> 32);
        zz[zzOff + 7] = n5 << 1 | n2;
    }

    public static int sub(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) - ((long)y[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) - ((long)y[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) - ((long)y[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) - ((long)y[3] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int sub(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) - ((long)y[yOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) - ((long)y[yOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) - ((long)y[yOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) - ((long)y[yOff + 3] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subBothFrom(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) - ((long)x[0] & 0xFFFFFFFFL) - ((long)y[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - ((long)x[1] & 0xFFFFFFFFL) - ((long)y[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) - ((long)x[2] & 0xFFFFFFFFL) - ((long)y[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)z[3] & 0xFFFFFFFFL) - ((long)x[3] & 0xFFFFFFFFL) - ((long)y[3] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) - ((long)x[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - ((long)x[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) - ((long)x[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)z[3] & 0xFFFFFFFFL) - ((long)x[3] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x, int xOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)z[zOff + 0] & 0xFFFFFFFFL) - ((long)x[xOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)z[zOff + 1] & 0xFFFFFFFFL) - ((long)x[xOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 2] = (int)(l2 += ((long)z[zOff + 2] & 0xFFFFFFFFL) - ((long)x[xOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 3] = (int)(l2 += ((long)z[zOff + 3] & 0xFFFFFFFFL) - ((long)x[xOff + 3] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static BigInteger toBigInteger(int[] x) {
        byte[] byArray = new byte[16];
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = x[i2];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, 3 - i2 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] x) {
        byte[] byArray = new byte[16];
        for (int i2 = 0; i2 < 2; ++i2) {
            long l2 = x[i2];
            if (l2 == 0L) continue;
            Pack.longToBigEndian(l2, byArray, 1 - i2 << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] z) {
        z[0] = 0;
        z[1] = 0;
        z[2] = 0;
        z[3] = 0;
    }
}

