/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.asn1.CMCEPublicKey;
import com.enterprisedt.bouncycastle.util.Arrays;

public class CMCEPrivateKey
extends ASN1Object {
    private int a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private CMCEPublicKey g;

    public CMCEPrivateKey(int version, byte[] delta, byte[] c2, byte[] g2, byte[] alpha, byte[] s2) {
        this(version, delta, c2, g2, alpha, s2, null);
    }

    public CMCEPrivateKey(int version, byte[] delta, byte[] c2, byte[] g2, byte[] alpha, byte[] s2, CMCEPublicKey pubKey) {
        this.a = version;
        if (version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = Arrays.clone(delta);
        this.c = Arrays.clone(c2);
        this.d = Arrays.clone(g2);
        this.e = Arrays.clone(alpha);
        this.f = Arrays.clone(s2);
        this.g = pubKey;
    }

    private CMCEPrivateKey(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.a != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        this.d = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(3)).getOctets());
        this.e = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(4)).getOctets());
        this.f = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(5)).getOctets());
        if (seq.size() == 7) {
            this.g = CMCEPublicKey.getInstance(seq.getObjectAt(6));
        }
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getDelta() {
        return Arrays.clone(this.b);
    }

    public byte[] getC() {
        return Arrays.clone(this.c);
    }

    public byte[] getG() {
        return Arrays.clone(this.d);
    }

    public byte[] getAlpha() {
        return Arrays.clone(this.e);
    }

    public byte[] getS() {
        return Arrays.clone(this.f);
    }

    public CMCEPublicKey getPublicKey() {
        return this.g;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new DEROctetString(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        aSN1EncodableVector.add(new DEROctetString(this.d));
        aSN1EncodableVector.add(new DEROctetString(this.e));
        aSN1EncodableVector.add(new DEROctetString(this.f));
        if (this.g != null) {
            aSN1EncodableVector.add(new CMCEPublicKey(this.g.getT()));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public static CMCEPrivateKey getInstance(Object o2) {
        if (o2 instanceof CMCEPrivateKey) {
            return (CMCEPrivateKey)o2;
        }
        if (o2 != null) {
            return new CMCEPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

