/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class KyberPublicKey
extends ASN1Object {
    private byte[] a;
    private byte[] b;

    public KyberPublicKey(byte[] t2, byte[] rho) {
        this.a = t2;
        this.b = rho;
    }

    public KyberPublicKey(ASN1Sequence seq) {
        this.a = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
        this.b = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
    }

    public byte[] getT() {
        return Arrays.clone(this.a);
    }

    public byte[] getRho() {
        return Arrays.clone(this.b);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.a));
        aSN1EncodableVector.add(new DEROctetString(this.b));
        return new DERSequence(aSN1EncodableVector);
    }

    public static KyberPublicKey getInstance(Object o2) {
        if (o2 instanceof KyberPublicKey) {
            return (KyberPublicKey)o2;
        }
        if (o2 != null) {
            return new KyberPublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

