/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;

public class McElieceCCA2PrivateKey
extends ASN1Object {
    private int a;
    private int b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private AlgorithmIdentifier f;

    public McElieceCCA2PrivateKey(int n2, int k2, GF2mField field, PolynomialGF2mSmallM goppaPoly, Permutation p2, AlgorithmIdentifier digest) {
        this.a = n2;
        this.b = k2;
        this.c = field.getEncoded();
        this.d = goppaPoly.getEncoded();
        this.e = p2.getEncoded();
        this.f = digest;
    }

    private McElieceCCA2PrivateKey(ASN1Sequence seq) {
        this.a = ((ASN1Integer)seq.getObjectAt(0)).intValueExact();
        this.b = ((ASN1Integer)seq.getObjectAt(1)).intValueExact();
        this.c = ((ASN1OctetString)seq.getObjectAt(2)).getOctets();
        this.d = ((ASN1OctetString)seq.getObjectAt(3)).getOctets();
        this.e = ((ASN1OctetString)seq.getObjectAt(4)).getOctets();
        this.f = AlgorithmIdentifier.getInstance(seq.getObjectAt(5));
    }

    public int getN() {
        return this.a;
    }

    public int getK() {
        return this.b;
    }

    public GF2mField getField() {
        return new GF2mField(this.c);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return new PolynomialGF2mSmallM(this.getField(), this.d);
    }

    public Permutation getP() {
        return new Permutation(this.e);
    }

    public AlgorithmIdentifier getDigest() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        aSN1EncodableVector.add(new DEROctetString(this.d));
        aSN1EncodableVector.add(new DEROctetString(this.e));
        aSN1EncodableVector.add(this.f);
        return new DERSequence(aSN1EncodableVector);
    }

    public static McElieceCCA2PrivateKey getInstance(Object o2) {
        if (o2 instanceof McElieceCCA2PrivateKey) {
            return (McElieceCCA2PrivateKey)o2;
        }
        if (o2 != null) {
            return new McElieceCCA2PrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

