/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Matrix;

public class McElieceCCA2PublicKey
extends ASN1Object {
    private final int a;
    private final int b;
    private final GF2Matrix c;
    private final AlgorithmIdentifier d;

    public McElieceCCA2PublicKey(int n2, int t2, GF2Matrix g2, AlgorithmIdentifier digest) {
        this.a = n2;
        this.b = t2;
        this.c = new GF2Matrix(g2.getEncoded());
        this.d = digest;
    }

    private McElieceCCA2PublicKey(ASN1Sequence seq) {
        this.a = ((ASN1Integer)seq.getObjectAt(0)).intValueExact();
        this.b = ((ASN1Integer)seq.getObjectAt(1)).intValueExact();
        this.c = new GF2Matrix(((ASN1OctetString)seq.getObjectAt(2)).getOctets());
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(3));
    }

    public int getN() {
        return this.a;
    }

    public int getT() {
        return this.b;
    }

    public GF2Matrix getG() {
        return this.c;
    }

    public AlgorithmIdentifier getDigest() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c.getEncoded()));
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }

    public static McElieceCCA2PublicKey getInstance(Object o2) {
        if (o2 instanceof McElieceCCA2PublicKey) {
            return (McElieceCCA2PublicKey)o2;
        }
        if (o2 != null) {
            return new McElieceCCA2PublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

