/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SPHINCS256KeyParams
extends ASN1Object {
    private final ASN1Integer a;
    private final AlgorithmIdentifier b;

    public SPHINCS256KeyParams(AlgorithmIdentifier treeDigest) {
        this.a = new ASN1Integer(0L);
        this.b = treeDigest;
    }

    private SPHINCS256KeyParams(ASN1Sequence sequence) {
        this.a = ASN1Integer.getInstance(sequence.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(sequence.getObjectAt(1));
    }

    public static final SPHINCS256KeyParams getInstance(Object o2) {
        if (o2 instanceof SPHINCS256KeyParams) {
            return (SPHINCS256KeyParams)o2;
        }
        if (o2 != null) {
            return new SPHINCS256KeyParams(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public AlgorithmIdentifier getTreeDigest() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

