/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.asn1.SPHINCSPLUSPublicKey;
import com.enterprisedt.bouncycastle.util.Arrays;

public class SPHINCSPLUSPrivateKey
extends ASN1Object {
    private int a;
    private byte[] b;
    private byte[] c;
    private SPHINCSPLUSPublicKey d;

    public int getVersion() {
        return this.a;
    }

    public byte[] getSkseed() {
        return Arrays.clone(this.b);
    }

    public byte[] getSkprf() {
        return Arrays.clone(this.c);
    }

    public SPHINCSPLUSPublicKey getPublicKey() {
        return this.d;
    }

    public SPHINCSPLUSPrivateKey(int version, byte[] skseed, byte[] skprf) {
        this(version, skseed, skprf, null);
    }

    public SPHINCSPLUSPrivateKey(int version, byte[] skseed, byte[] skprf, SPHINCSPLUSPublicKey publicKey) {
        this.a = version;
        this.b = skseed;
        this.c = skprf;
        this.d = publicKey;
    }

    public SPHINCSPLUSPrivateKey(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.a != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        if (seq.size() == 4) {
            this.d = SPHINCSPLUSPublicKey.getInstance(seq.getObjectAt(3));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new DEROctetString(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        if (this.d != null) {
            aSN1EncodableVector.add(new SPHINCSPLUSPublicKey(this.d.getPkseed(), this.d.getPkroot()));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public static SPHINCSPLUSPrivateKey getInstance(Object o2) {
        if (o2 instanceof SPHINCSPLUSPrivateKey) {
            return (SPHINCSPLUSPrivateKey)o2;
        }
        if (o2 != null) {
            return new SPHINCSPLUSPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

