/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class XMSSMTPublicKey
extends ASN1Object {
    private final byte[] a;
    private final byte[] b;

    public XMSSMTPublicKey(byte[] publicSeed, byte[] root) {
        this.a = Arrays.clone(publicSeed);
        this.b = Arrays.clone(root);
    }

    private XMSSMTPublicKey(ASN1Sequence seq) {
        if (!ASN1Integer.getInstance(seq.getObjectAt(0)).hasValue(0)) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.a = Arrays.clone(DEROctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.b = Arrays.clone(DEROctetString.getInstance(seq.getObjectAt(2)).getOctets());
    }

    public static XMSSMTPublicKey getInstance(Object o2) {
        if (o2 instanceof XMSSMTPublicKey) {
            return (XMSSMTPublicKey)o2;
        }
        if (o2 != null) {
            return new XMSSMTPublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.a);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.b);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(0L));
        aSN1EncodableVector.add(new DEROctetString(this.a));
        aSN1EncodableVector.add(new DEROctetString(this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

