/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.cmce;

import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.d;
import com.enterprisedt.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class CMCEKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom a;

    public CMCEKEMGenerator(SecureRandom random) {
        this.a = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)recipientKey;
        d d2 = cMCEPublicKeyParameters.getParameters().a();
        return this.generateEncapsulated(recipientKey, d2.d());
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey, int sessionKeySizeInBits) {
        CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)recipientKey;
        d d2 = cMCEPublicKeyParameters.getParameters().a();
        byte[] byArray = new byte[d2.c()];
        byte[] byArray2 = new byte[sessionKeySizeInBits / 8];
        d2.a(byArray, byArray2, cMCEPublicKeyParameters.getPublicKey(), this.a);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

