/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber;

import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.b;
import com.enterprisedt.bouncycastle.util.Arrays;

public class KyberPrivateKeyParameters
extends KyberKeyParameters {
    final byte[] b;
    final byte[] c;
    final byte[] d;
    final byte[] e;
    final byte[] f;

    public KyberPrivateKeyParameters(KyberParameters params, byte[] s2, byte[] hpk, byte[] nonce, byte[] t2, byte[] rho) {
        super(true, params);
        this.b = Arrays.clone(s2);
        this.c = Arrays.clone(hpk);
        this.d = Arrays.clone(nonce);
        this.e = Arrays.clone(t2);
        this.f = Arrays.clone(rho);
    }

    public KyberPrivateKeyParameters(KyberParameters params, byte[] encoding) {
        super(true, params);
        b b2 = params.a();
        int n2 = 0;
        this.b = Arrays.copyOfRange(encoding, 0, b2.f());
        this.e = Arrays.copyOfRange(encoding, n2 += b2.f(), n2 + b2.e() - 32);
        this.f = Arrays.copyOfRange(encoding, n2 += b2.e() - 32, n2 + 32);
        this.c = Arrays.copyOfRange(encoding, n2 += 32, n2 + 32);
        this.d = Arrays.copyOfRange(encoding, n2 += 32, n2 + 32);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.b, this.e, this.f, this.c, this.d});
    }

    public byte[] getHPK() {
        return Arrays.clone(this.c);
    }

    public byte[] getNonce() {
        return Arrays.clone(this.d);
    }

    public byte[] getPrivateKey() {
        return this.getEncoded();
    }

    public byte[] getPublicKey() {
        return KyberPublicKeyParameters.a(this.e, this.f);
    }

    public KyberPublicKeyParameters getPublicKeyParameters() {
        return new KyberPublicKeyParameters(this.getParameters(), this.e, this.f);
    }

    public byte[] getRho() {
        return Arrays.clone(this.f);
    }

    public byte[] getS() {
        return Arrays.clone(this.b);
    }

    public byte[] getT() {
        return Arrays.clone(this.e);
    }
}

