/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.lms;

import com.enterprisedt.bouncycastle.pqc.crypto.lms.Composer;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContext;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.c;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.g;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.h;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.i;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HSSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final int b;
    private final LMSPublicKeyParameters c;

    public HSSPublicKeyParameters(int l2, LMSPublicKeyParameters lmsPublicKey) {
        super(false);
        this.b = l2;
        this.c = lmsPublicKey;
    }

    public static HSSPublicKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof HSSPublicKeyParameters) {
            return (HSSPublicKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            int n2 = ((DataInputStream)src).readInt();
            LMSPublicKeyParameters lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(src);
            return new HSSPublicKeyParameters(n2, lMSPublicKeyParameters);
        }
        if (src instanceof byte[]) {
            try (InputStream inputStream = null;){
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])src));
                HSSPublicKeyParameters hSSPublicKeyParameters = HSSPublicKeyParameters.getInstance(inputStream);
                return hSSPublicKeyParameters;
            }
        }
        if (src instanceof InputStream) {
            return HSSPublicKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public int getL() {
        return this.b;
    }

    public LMSPublicKeyParameters getLMSPublicKey() {
        return this.c;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        HSSPublicKeyParameters hSSPublicKeyParameters = (HSSPublicKeyParameters)o2;
        if (this.b != hSSPublicKeyParameters.b) {
            return false;
        }
        return this.c.equals(hSSPublicKeyParameters.c);
    }

    public int hashCode() {
        int n2 = this.b;
        n2 = 31 * n2 + this.c.hashCode();
        return n2;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.b).bytes(this.c.getEncoded()).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] sigEnc) {
        c c2;
        try {
            c2 = com.enterprisedt.bouncycastle.pqc.crypto.lms.c.a(sigEnc, this.getL());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot parse signature: " + iOException.getMessage());
        }
        i[] iArray = c2.b();
        LMSPublicKeyParameters lMSPublicKeyParameters = iArray.length != 0 ? iArray[iArray.length - 1].b() : this.getLMSPublicKey();
        return lMSPublicKeyParameters.a(c2.c()).a(iArray);
    }

    @Override
    public boolean verify(LMSContext context) {
        boolean bl = false;
        i[] iArray = context.f();
        if (iArray.length != this.getL() - 1) {
            return false;
        }
        LMSPublicKeyParameters lMSPublicKeyParameters = this.getLMSPublicKey();
        for (int i2 = 0; i2 < iArray.length; ++i2) {
            byte[] byArray;
            h h2 = iArray[i2].a();
            if (!g.a(lMSPublicKeyParameters, h2, byArray = iArray[i2].b().a())) {
                bl = true;
            }
            lMSPublicKeyParameters = iArray[i2].b();
        }
        return !bl & lMSPublicKeyParameters.verify(context);
    }
}

