/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.newhope;

import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.util.DEROtherInfo;
import com.enterprisedt.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.enterprisedt.bouncycastle.pqc.crypto.ExchangePair;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHAgreement;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import java.io.IOException;
import java.security.SecureRandom;

public class NHOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected boolean used = false;

    public NHOtherInfoGenerator(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmID, partyUInfo, partyVInfo);
        this.random = random;
    }

    private static byte[] b(NHPublicKeyParameters nHPublicKeyParameters) {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, nHPublicKeyParameters.getPubData());
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static NHPublicKeyParameters b(byte[] byArray) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(byArray);
        return new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getOctets());
    }

    public static class PartyV
    extends NHOtherInfoGenerator {
        public PartyV(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] suppPrivInfoPartA) {
            NHExchangePairGenerator nHExchangePairGenerator = new NHExchangePairGenerator(this.random);
            ExchangePair exchangePair = nHExchangePairGenerator.generateExchange(NHOtherInfoGenerator.b(suppPrivInfoPartA));
            this.otherInfoBuilder.withSuppPrivInfo(exchangePair.getSharedValue());
            return NHOtherInfoGenerator.b((NHPublicKeyParameters)exchangePair.getPublicKey());
        }

        public DEROtherInfo generate() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyU
    extends NHOtherInfoGenerator {
        private AsymmetricCipherKeyPair a;
        private NHAgreement b = new NHAgreement();

        public PartyU(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(new KeyGenerationParameters(random, 2048));
            this.a = nHKeyPairGenerator.generateKeyPair();
            this.b.init(this.a.getPrivate());
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return NHOtherInfoGenerator.b((NHPublicKeyParameters)this.a.getPublic());
        }

        public DEROtherInfo generate(byte[] suppPrivInfoPartB) {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            this.otherInfoBuilder.withSuppPrivInfo(this.b.calculateAgreement(NHOtherInfoGenerator.b(suppPrivInfoPartB)));
            return this.otherInfoBuilder.build();
        }
    }
}

