/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.newhope;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.SHAKEDigest;
import com.enterprisedt.bouncycastle.pqc.crypto.ExchangePair;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHAgreement;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class NHSecretKeyProcessor {
    private final Xof a = new SHAKEDigest(256);

    private NHSecretKeyProcessor(byte[] secret, byte[] shared) {
        this.a.update(secret, 0, secret.length);
        if (shared != null) {
            this.a.update(shared, 0, shared.length);
        }
        Arrays.fill(secret, (byte)0);
    }

    public byte[] processKey(byte[] initialKey) {
        byte[] byArray = new byte[initialKey.length];
        this.a.doFinal(byArray, 0, byArray.length);
        NHSecretKeyProcessor.a(initialKey, byArray);
        Arrays.fill(byArray, (byte)0);
        return initialKey;
    }

    private static void a(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i2]);
        }
    }

    public static class PartyVBuilder {
        protected final SecureRandom random;
        private byte[] a = null;
        private byte[] b = null;
        private boolean c = false;

        public PartyVBuilder(SecureRandom random) {
            this.random = random;
        }

        public PartyVBuilder withSharedInfo(byte[] sharedInfo) {
            this.a = Arrays.clone(sharedInfo);
            return this;
        }

        public byte[] getPartB(byte[] partUContribution) {
            NHExchangePairGenerator nHExchangePairGenerator = new NHExchangePairGenerator(this.random);
            ExchangePair exchangePair = nHExchangePairGenerator.generateExchange(new NHPublicKeyParameters(partUContribution));
            this.b = exchangePair.getSharedValue();
            return ((NHPublicKeyParameters)exchangePair.getPublicKey()).getPubData();
        }

        public NHSecretKeyProcessor build() {
            if (this.c) {
                throw new IllegalStateException("builder already used");
            }
            this.c = true;
            return new NHSecretKeyProcessor(this.b, this.a);
        }
    }

    public static class PartyUBuilder {
        private final AsymmetricCipherKeyPair a;
        private final NHAgreement b = new NHAgreement();
        private byte[] c = null;
        private boolean d = false;

        public PartyUBuilder(SecureRandom random) {
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(new KeyGenerationParameters(random, 2048));
            this.a = nHKeyPairGenerator.generateKeyPair();
            this.b.init(this.a.getPrivate());
        }

        public PartyUBuilder withSharedInfo(byte[] sharedInfo) {
            this.c = Arrays.clone(sharedInfo);
            return this;
        }

        public byte[] getPartA() {
            return ((NHPublicKeyParameters)this.a.getPublic()).getPubData();
        }

        public NHSecretKeyProcessor build(byte[] partB) {
            if (this.d) {
                throw new IllegalStateException("builder already used");
            }
            this.d = true;
            return new NHSecretKeyProcessor(this.b.calculateAgreement(new NHPublicKeyParameters(partB)), this.c);
        }
    }
}

