/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntruprime;

import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public class NTRULPRimePublicKeyParameters
extends NTRULPRimeKeyParameters {
    private final byte[] b;
    private final byte[] c;

    public NTRULPRimePublicKeyParameters(NTRULPRimeParameters params, byte[] encoding) {
        super(false, params);
        this.b = Arrays.copyOfRange(encoding, 0, 32);
        this.c = Arrays.copyOfRange(encoding, this.b.length, encoding.length);
    }

    NTRULPRimePublicKeyParameters(NTRULPRimeParameters params, byte[] seed, byte[] roundEncA) {
        super(false, params);
        this.b = Arrays.clone(seed);
        this.c = Arrays.clone(roundEncA);
    }

    byte[] a() {
        return this.b;
    }

    byte[] b() {
        return this.c;
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[this.getParameters().getPublicKeyBytes()];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        System.arraycopy(this.c, 0, byArray, this.b.length, this.c.length);
        return byArray;
    }
}

