/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntruprime;

import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a;
import com.enterprisedt.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class SNTRUPrimeKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom a;

    public SNTRUPrimeKEMGenerator(SecureRandom random) {
        this.a = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        SNTRUPrimePublicKeyParameters sNTRUPrimePublicKeyParameters = (SNTRUPrimePublicKeyParameters)recipientKey;
        SNTRUPrimeParameters sNTRUPrimeParameters = sNTRUPrimePublicKeyParameters.getParameters();
        int n2 = sNTRUPrimeParameters.getP();
        int n3 = sNTRUPrimeParameters.getQ();
        int n4 = sNTRUPrimeParameters.getW();
        int n5 = sNTRUPrimeParameters.getRoundedPolynomialBytes();
        byte[] byArray = new byte[]{4};
        byte[] byArray2 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray, sNTRUPrimePublicKeyParameters.getEncoded());
        byte[] byArray3 = new byte[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(this.a, byArray3, n2, n4);
        byte[] byArray4 = new byte[(n2 + 3) / 4];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.b(byArray4, byArray3, n2);
        short[] sArray = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.c(sArray, sNTRUPrimePublicKeyParameters.a(), n2, n3);
        short[] sArray2 = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(sArray2, sArray, byArray3, n2, n3);
        short[] sArray3 = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(sArray3, sArray2);
        byte[] byArray5 = new byte[n5];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.b(byArray5, sArray3, n2, n3);
        byte[] byArray6 = new byte[]{3};
        byte[] byArray7 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray6, byArray4);
        byte[] byArray8 = new byte[byArray7.length / 2 + byArray2.length / 2];
        System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length / 2);
        System.arraycopy(byArray2, 0, byArray8, byArray7.length / 2, byArray2.length / 2);
        byte[] byArray9 = new byte[]{2};
        byte[] byArray10 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray9, byArray8);
        byte[] byArray11 = new byte[byArray5.length + byArray10.length / 2];
        System.arraycopy(byArray5, 0, byArray11, 0, byArray5.length);
        System.arraycopy(byArray10, 0, byArray11, byArray5.length, byArray10.length / 2);
        byte[] byArray12 = new byte[]{3};
        byte[] byArray13 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray12, byArray4);
        byte[] byArray14 = new byte[byArray13.length / 2 + byArray11.length];
        System.arraycopy(byArray13, 0, byArray14, 0, byArray13.length / 2);
        System.arraycopy(byArray11, 0, byArray14, byArray13.length / 2, byArray11.length);
        byte[] byArray15 = new byte[]{1};
        byte[] byArray16 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray15, byArray14);
        byte[] byArray17 = Arrays.copyOfRange(byArray16, 0, sNTRUPrimeParameters.getSessionKeySize() / 8);
        return new SecretWithEncapsulationImpl(byArray17, byArray11);
    }
}

