/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntruprime;

import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public class SNTRUPrimePrivateKeyParameters
extends SNTRUPrimeKeyParameters {
    private final byte[] b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;

    public SNTRUPrimePrivateKeyParameters(SNTRUPrimeParameters params, byte[] f2, byte[] ginv, byte[] pk, byte[] rho, byte[] hash) {
        super(true, params);
        this.b = Arrays.clone(f2);
        this.c = Arrays.clone(ginv);
        this.d = Arrays.clone(pk);
        this.e = Arrays.clone(rho);
        this.f = Arrays.clone(hash);
    }

    public byte[] getF() {
        return Arrays.clone(this.b);
    }

    public byte[] getGinv() {
        return Arrays.clone(this.c);
    }

    public byte[] getPk() {
        return Arrays.clone(this.d);
    }

    public byte[] getRho() {
        return Arrays.clone(this.e);
    }

    public byte[] getHash() {
        return Arrays.clone(this.f);
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[this.getParameters().getPrivateKeyBytes()];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        System.arraycopy(this.c, 0, byArray, this.b.length, this.c.length);
        System.arraycopy(this.d, 0, byArray, this.b.length + this.c.length, this.d.length);
        System.arraycopy(this.e, 0, byArray, this.b.length + this.c.length + this.d.length, this.e.length);
        System.arraycopy(this.f, 0, byArray, this.b.length + this.c.length + this.d.length + this.e.length, this.f.length);
        return byArray;
    }
}

