/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.asn1.CMCEPrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.FalconPrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.enterprisedt.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.SPHINCSPLUSPrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.SPHINCSPLUSPublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.enterprisedt.bouncycastle.pqc.crypto.bike.BIKEParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.hqc.HQCParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.saber.SABERParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.enterprisedt.bouncycastle.pqc.crypto.util.a;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;
import java.io.InputStream;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        if (privateKeyInfoData == null) {
            throw new IllegalArgumentException("privateKeyInfoData array null");
        }
        if (privateKeyInfoData.length == 0) {
            throw new IllegalArgumentException("privateKeyInfoData array empty");
        }
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo array null");
        }
        AlgorithmIdentifier algorithmIdentifier = keyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (aSN1ObjectIdentifier.on(PQCObjectIdentifiers.qTESLA)) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(keyInfo.parsePrivateKey());
            return new QTESLAPrivateKeyParameters(a.a(algorithmIdentifier), aSN1OctetString.getOctets());
        }
        if (aSN1ObjectIdentifier.equals(PQCObjectIdentifiers.sphincs256)) {
            return new SPHINCSPrivateKeyParameters(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets(), a.a(SPHINCS256KeyParams.getInstance(algorithmIdentifier.getParameters())));
        }
        if (aSN1ObjectIdentifier.equals(PQCObjectIdentifiers.newHope)) {
            return new NHPrivateKeyParameters(PrivateKeyFactory.a(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets()));
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            ASN1BitString aSN1BitString = keyInfo.getPublicKeyData();
            if (Pack.bigEndianToInt(byArray, 0) == 1) {
                if (aSN1BitString != null) {
                    byte[] byArray2 = aSN1BitString.getOctets();
                    return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length), Arrays.copyOfRange(byArray2, 4, byArray2.length));
                }
                return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length));
            }
            if (aSN1BitString != null) {
                byte[] byArray3 = aSN1BitString.getOctets();
                return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length), byArray3);
            }
            return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length));
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.sphincsPlus) || aSN1ObjectIdentifier.on(BCObjectIdentifiers.sphincsPlus_interop)) {
            SPHINCSPlusParameters sPHINCSPlusParameters = a.c(aSN1ObjectIdentifier);
            ASN1Encodable aSN1Encodable = keyInfo.parsePrivateKey();
            if (aSN1Encodable instanceof ASN1Sequence) {
                SPHINCSPLUSPrivateKey sPHINCSPLUSPrivateKey = SPHINCSPLUSPrivateKey.getInstance(aSN1Encodable);
                SPHINCSPLUSPublicKey sPHINCSPLUSPublicKey = sPHINCSPLUSPrivateKey.getPublicKey();
                return new SPHINCSPlusPrivateKeyParameters(sPHINCSPlusParameters, sPHINCSPLUSPrivateKey.getSkseed(), sPHINCSPLUSPrivateKey.getSkprf(), sPHINCSPLUSPublicKey.getPkseed(), sPHINCSPLUSPublicKey.getPkroot());
            }
            return new SPHINCSPlusPrivateKeyParameters(sPHINCSPlusParameters, ASN1OctetString.getInstance(aSN1Encodable).getOctets());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.picnic)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            PicnicParameters picnicParameters = a.g(aSN1ObjectIdentifier);
            return new PicnicPrivateKeyParameters(picnicParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_mceliece)) {
            CMCEPrivateKey cMCEPrivateKey = CMCEPrivateKey.getInstance(keyInfo.parsePrivateKey());
            CMCEParameters cMCEParameters = a.d(aSN1ObjectIdentifier);
            return new CMCEPrivateKeyParameters(cMCEParameters, cMCEPrivateKey.getDelta(), cMCEPrivateKey.getC(), cMCEPrivateKey.getG(), cMCEPrivateKey.getAlpha(), cMCEPrivateKey.getS());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_frodo)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            FrodoParameters frodoParameters = a.e(aSN1ObjectIdentifier);
            return new FrodoPrivateKeyParameters(frodoParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_saber)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            SABERParameters sABERParameters = a.f(aSN1ObjectIdentifier);
            return new SABERPrivateKeyParameters(sABERParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_ntru)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            NTRUParameters nTRUParameters = a.i(aSN1ObjectIdentifier);
            return new NTRUPrivateKeyParameters(nTRUParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_kyber)) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(keyInfo.parsePrivateKey());
            KyberParameters kyberParameters = a.j(aSN1ObjectIdentifier);
            return new KyberPrivateKeyParameters(kyberParameters, aSN1OctetString.getOctets());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_ntrulprime)) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(keyInfo.parsePrivateKey());
            NTRULPRimeParameters nTRULPRimeParameters = a.k(aSN1ObjectIdentifier);
            return new NTRULPRimePrivateKeyParameters(nTRULPRimeParameters, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(3)).getOctets());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_sntruprime)) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(keyInfo.parsePrivateKey());
            SNTRUPrimeParameters sNTRUPrimeParameters = a.l(aSN1ObjectIdentifier);
            return new SNTRUPrimePrivateKeyParameters(sNTRUPrimeParameters, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(3)).getOctets(), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(4)).getOctets());
        }
        if (aSN1ObjectIdentifier.equals(BCObjectIdentifiers.dilithium2) || aSN1ObjectIdentifier.equals(BCObjectIdentifiers.dilithium3) || aSN1ObjectIdentifier.equals(BCObjectIdentifiers.dilithium5)) {
            ASN1Encodable aSN1Encodable = keyInfo.parsePrivateKey();
            DilithiumParameters dilithiumParameters = a.m(aSN1ObjectIdentifier);
            if (aSN1Encodable instanceof ASN1Sequence) {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Encodable);
                int n2 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).intValueExact();
                if (n2 != 0) {
                    throw new IOException("unknown private key version: " + n2);
                }
                if (keyInfo.getPublicKeyData() != null) {
                    DilithiumPublicKeyParameters dilithiumPublicKeyParameters = PublicKeyFactory.c.a(dilithiumParameters, keyInfo.getPublicKeyData());
                    return new DilithiumPrivateKeyParameters(dilithiumParameters, ASN1BitString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(3)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(4)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(5)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(6)).getOctets(), dilithiumPublicKeyParameters.getT1());
                }
                return new DilithiumPrivateKeyParameters(dilithiumParameters, ASN1BitString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(3)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(4)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(5)).getOctets(), ASN1BitString.getInstance(aSN1Sequence.getObjectAt(6)).getOctets(), null);
            }
            if (aSN1Encodable instanceof DEROctetString) {
                byte[] byArray = ASN1OctetString.getInstance(aSN1Encodable).getOctets();
                if (keyInfo.getPublicKeyData() != null) {
                    DilithiumPublicKeyParameters dilithiumPublicKeyParameters = PublicKeyFactory.c.a(dilithiumParameters, keyInfo.getPublicKeyData());
                    return new DilithiumPrivateKeyParameters(dilithiumParameters, byArray, dilithiumPublicKeyParameters);
                }
                return new DilithiumPrivateKeyParameters(dilithiumParameters, byArray, null);
            }
            throw new IOException("not supported");
        }
        if (aSN1ObjectIdentifier.equals(BCObjectIdentifiers.falcon_512) || aSN1ObjectIdentifier.equals(BCObjectIdentifiers.falcon_1024)) {
            FalconPrivateKey falconPrivateKey = FalconPrivateKey.getInstance(keyInfo.parsePrivateKey());
            FalconParameters falconParameters = a.h(aSN1ObjectIdentifier);
            return new FalconPrivateKeyParameters(falconParameters, falconPrivateKey.getf(), falconPrivateKey.getG(), falconPrivateKey.getF(), falconPrivateKey.getPublicKey().getH());
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_bike)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            BIKEParameters bIKEParameters = a.n(aSN1ObjectIdentifier);
            byte[] byArray4 = Arrays.copyOfRange(byArray, 0, bIKEParameters.getRByte());
            byte[] byArray5 = Arrays.copyOfRange(byArray, bIKEParameters.getRByte(), 2 * bIKEParameters.getRByte());
            byte[] byArray6 = Arrays.copyOfRange(byArray, 2 * bIKEParameters.getRByte(), byArray.length);
            return new BIKEPrivateKeyParameters(bIKEParameters, byArray4, byArray5, byArray6);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.pqc_kem_hqc)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            HQCParameters hQCParameters = a.o(aSN1ObjectIdentifier);
            return new HQCPrivateKeyParameters(hQCParameters, byArray);
        }
        if (aSN1ObjectIdentifier.on(BCObjectIdentifiers.rainbow)) {
            byte[] byArray = ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            RainbowParameters rainbowParameters = a.p(aSN1ObjectIdentifier);
            return new RainbowPrivateKeyParameters(rainbowParameters, byArray);
        }
        if (aSN1ObjectIdentifier.equals(PQCObjectIdentifiers.xmss)) {
            XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance(algorithmIdentifier.getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = xMSSKeyParams.getTreeDigest().getAlgorithm();
            XMSSPrivateKey xMSSPrivateKey = XMSSPrivateKey.getInstance(keyInfo.parsePrivateKey());
            try {
                XMSSPrivateKeyParameters.Builder builder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), a.a(aSN1ObjectIdentifier2))).withIndex(xMSSPrivateKey.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
                if (xMSSPrivateKey.getVersion() != 0) {
                    builder.withMaxIndex(xMSSPrivateKey.getMaxIndex());
                }
                if (xMSSPrivateKey.getBdsState() != null) {
                    BDS bDS = (BDS)XMSSUtil.deserialize(xMSSPrivateKey.getBdsState(), BDS.class);
                    builder.withBDSState(bDS.withWOTSDigest(aSN1ObjectIdentifier2));
                }
                return builder.build();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
            }
        }
        if (aSN1ObjectIdentifier.equals(PQCObjectIdentifiers.xmss_mt)) {
            XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance(algorithmIdentifier.getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier3 = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
            try {
                XMSSMTPrivateKey xMSSMTPrivateKey = XMSSMTPrivateKey.getInstance(keyInfo.parsePrivateKey());
                XMSSMTPrivateKeyParameters.Builder builder = new XMSSMTPrivateKeyParameters.Builder(new XMSSMTParameters(xMSSMTKeyParams.getHeight(), xMSSMTKeyParams.getLayers(), a.a(aSN1ObjectIdentifier3))).withIndex(xMSSMTPrivateKey.getIndex()).withSecretKeySeed(xMSSMTPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSMTPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSMTPrivateKey.getPublicSeed()).withRoot(xMSSMTPrivateKey.getRoot());
                if (xMSSMTPrivateKey.getVersion() != 0) {
                    builder.withMaxIndex(xMSSMTPrivateKey.getMaxIndex());
                }
                if (xMSSMTPrivateKey.getBdsState() != null) {
                    BDSStateMap bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(xMSSMTPrivateKey.getBdsState(), BDSStateMap.class);
                    builder.withBDSState(bDSStateMap.withWOTSDigest(aSN1ObjectIdentifier3));
                }
                return builder.build();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
            }
        }
        if (aSN1ObjectIdentifier.equals(PQCObjectIdentifiers.mcElieceCca2)) {
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = McElieceCCA2PrivateKey.getInstance(keyInfo.parsePrivateKey());
            return new McElieceCCA2PrivateKeyParameters(mcElieceCCA2PrivateKey.getN(), mcElieceCCA2PrivateKey.getK(), mcElieceCCA2PrivateKey.getField(), mcElieceCCA2PrivateKey.getGoppaPoly(), mcElieceCCA2PrivateKey.getP(), a.b(mcElieceCCA2PrivateKey.getDigest().getAlgorithm()));
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static short[] a(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i2 = 0; i2 != sArray.length; ++i2) {
            sArray[i2] = Pack.littleEndianToShort(byArray, i2 * 2);
        }
        return sArray;
    }
}

