/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.HashTreeAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.LTreeAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.a;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.d;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.f;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.g;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.i;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public final class BDS
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient d a;
    private final int b;
    private final List<a> c;
    private int d;
    private XMSSNode e;
    private List<XMSSNode> f;
    private Map<Integer, LinkedList<XMSSNode>> g;
    private Stack<XMSSNode> h;
    private Map<Integer, XMSSNode> i;
    private int j;
    private boolean k;
    private transient int l;

    BDS(XMSSParameters params, int maxIndex, int index) {
        this(params.d(), params.getHeight(), params.f(), index);
        this.l = maxIndex;
        this.j = index;
        this.k = true;
    }

    BDS(XMSSParameters params, byte[] publicSeed, byte[] secretKeySeed, OTSHashAddress otsHashAddress) {
        this(params.d(), params.getHeight(), params.f(), (1 << params.getHeight()) - 1);
        this.a(publicSeed, secretKeySeed, otsHashAddress);
    }

    BDS(XMSSParameters params, byte[] publicSeed, byte[] secretKeySeed, OTSHashAddress otsHashAddress, int index) {
        this(params.d(), params.getHeight(), params.f(), (1 << params.getHeight()) - 1);
        this.a(publicSeed, secretKeySeed, otsHashAddress);
        while (this.j < index) {
            this.b(publicSeed, secretKeySeed, otsHashAddress);
            this.k = false;
        }
    }

    private BDS(d wotsPlus, int treeHeight, int k2, int maxIndex) {
        this.a = wotsPlus;
        this.b = treeHeight;
        this.l = maxIndex;
        this.d = k2;
        if (k2 > treeHeight || k2 < 2 || (treeHeight - k2) % 2 != 0) {
            throw new IllegalArgumentException("illegal value for BDS parameter k");
        }
        this.f = new ArrayList<XMSSNode>();
        this.g = new TreeMap<Integer, LinkedList<XMSSNode>>();
        this.h = new Stack();
        this.c = new ArrayList<a>();
        for (int i2 = 0; i2 < treeHeight - k2; ++i2) {
            this.c.add(new a(i2));
        }
        this.i = new TreeMap<Integer, XMSSNode>();
        this.j = 0;
        this.k = false;
    }

    BDS(BDS last) {
        this.a = new d(last.a.a());
        this.b = last.b;
        this.d = last.d;
        this.e = last.e;
        this.f = new ArrayList<XMSSNode>();
        this.f.addAll(last.f);
        this.g = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n2 : last.g.keySet()) {
            this.g.put(n2, (LinkedList)last.g.get(n2).clone());
        }
        this.h = new Stack();
        this.h.addAll(last.h);
        this.c = new ArrayList<a>();
        Iterator<Serializable> iterator = last.c.iterator();
        while (iterator.hasNext()) {
            this.c.add(((a)iterator.next()).f());
        }
        this.i = new TreeMap<Integer, XMSSNode>(last.i);
        this.j = last.j;
        this.l = last.l;
        this.k = last.k;
    }

    private BDS(BDS last, byte[] publicSeed, byte[] secretKeySeed, OTSHashAddress otsHashAddress) {
        this.a = new d(last.a.a());
        this.b = last.b;
        this.d = last.d;
        this.e = last.e;
        this.f = new ArrayList<XMSSNode>();
        this.f.addAll(last.f);
        this.g = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n2 : last.g.keySet()) {
            this.g.put(n2, (LinkedList)last.g.get(n2).clone());
        }
        this.h = new Stack();
        this.h.addAll(last.h);
        this.c = new ArrayList<a>();
        Iterator<Serializable> iterator = last.c.iterator();
        while (iterator.hasNext()) {
            this.c.add(((a)iterator.next()).f());
        }
        this.i = new TreeMap<Integer, XMSSNode>(last.i);
        this.j = last.j;
        this.l = last.l;
        this.k = false;
        this.b(publicSeed, secretKeySeed, otsHashAddress);
    }

    private BDS(BDS last, ASN1ObjectIdentifier digest) {
        this.a = new d(new f(digest));
        this.b = last.b;
        this.d = last.d;
        this.e = last.e;
        this.f = new ArrayList<XMSSNode>();
        this.f.addAll(last.f);
        this.g = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n2 : last.g.keySet()) {
            this.g.put(n2, (LinkedList)last.g.get(n2).clone());
        }
        this.h = new Stack();
        this.h.addAll(last.h);
        this.c = new ArrayList<a>();
        Iterator<Serializable> iterator = last.c.iterator();
        while (iterator.hasNext()) {
            this.c.add(((a)iterator.next()).f());
        }
        this.i = new TreeMap<Integer, XMSSNode>(last.i);
        this.j = last.j;
        this.l = last.l;
        this.k = last.k;
        this.c();
    }

    private BDS(BDS last, int maxIndex, ASN1ObjectIdentifier digest) {
        this.a = new d(new f(digest));
        this.b = last.b;
        this.d = last.d;
        this.e = last.e;
        this.f = new ArrayList<XMSSNode>();
        this.f.addAll(last.f);
        this.g = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n2 : last.g.keySet()) {
            this.g.put(n2, (LinkedList)last.g.get(n2).clone());
        }
        this.h = new Stack();
        this.h.addAll(last.h);
        this.c = new ArrayList<a>();
        Iterator<Serializable> iterator = last.c.iterator();
        while (iterator.hasNext()) {
            this.c.add(((a)iterator.next()).f());
        }
        this.i = new TreeMap<Integer, XMSSNode>(last.i);
        this.j = last.j;
        this.l = maxIndex;
        this.k = last.k;
        this.c();
    }

    public BDS getNextState(byte[] publicSeed, byte[] secretKeySeed, OTSHashAddress otsHashAddress) {
        return new BDS(this, publicSeed, secretKeySeed, otsHashAddress);
    }

    private void a(byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        for (int i2 = 0; i2 < 1 << this.b; ++i2) {
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(i2).withChainAddress(oTSHashAddress.b()).withHashAddress(oTSHashAddress.c()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
            this.a.a(this.a.b(byArray2, oTSHashAddress), byArray);
            g g2 = this.a.a(oTSHashAddress);
            lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(i2).withTreeHeight(lTreeAddress.b()).withTreeIndex(lTreeAddress.c()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
            XMSSNode xMSSNode = com.enterprisedt.bouncycastle.pqc.crypto.xmss.i.a(this.a, g2, lTreeAddress);
            hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeIndex(i2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            while (!this.h.isEmpty() && this.h.peek().getHeight() == xMSSNode.getHeight()) {
                int n2 = i2 / (1 << xMSSNode.getHeight());
                if (n2 == 1) {
                    this.f.add(xMSSNode);
                }
                if (n2 == 3 && xMSSNode.getHeight() < this.b - this.d) {
                    this.c.get(xMSSNode.getHeight()).a(xMSSNode);
                }
                if (n2 >= 3 && (n2 & 1) == 1 && xMSSNode.getHeight() >= this.b - this.d && xMSSNode.getHeight() <= this.b - 2) {
                    if (this.g.get(xMSSNode.getHeight()) == null) {
                        LinkedList<XMSSNode> linkedList = new LinkedList<XMSSNode>();
                        linkedList.add(xMSSNode);
                        this.g.put(xMSSNode.getHeight(), linkedList);
                    } else {
                        this.g.get(xMSSNode.getHeight()).add(xMSSNode);
                    }
                }
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.a()).withTreeIndex((hashTreeAddress.b() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                xMSSNode = com.enterprisedt.bouncycastle.pqc.crypto.xmss.i.a(this.a, this.h.pop(), xMSSNode, hashTreeAddress);
                xMSSNode = new XMSSNode(xMSSNode.getHeight() + 1, xMSSNode.getValue());
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.a() + 1).withTreeIndex(hashTreeAddress.b()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            }
            this.h.push(xMSSNode);
        }
        this.e = this.h.pop();
    }

    private void b(byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        Serializable serializable;
        Object object;
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        if (this.k) {
            throw new IllegalStateException("index already used");
        }
        if (this.j > this.l - 1) {
            throw new IllegalStateException("index out of bounds");
        }
        int n2 = XMSSUtil.calculateTau(this.j, this.b);
        if ((this.j >> n2 + 1 & 1) == 0 && n2 < this.b - 1) {
            this.i.put(n2, this.f.get(n2));
        }
        LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        if (n2 == 0) {
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(this.j).withChainAddress(oTSHashAddress.b()).withHashAddress(oTSHashAddress.c()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
            this.a.a(this.a.b(byArray2, oTSHashAddress), byArray);
            object = this.a.a(oTSHashAddress);
            lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(this.j).withTreeHeight(lTreeAddress.b()).withTreeIndex(lTreeAddress.c()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
            serializable = com.enterprisedt.bouncycastle.pqc.crypto.xmss.i.a(this.a, (g)object, lTreeAddress);
            this.f.set(0, (XMSSNode)serializable);
        } else {
            int n3;
            hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(n2 - 1).withTreeIndex(this.j >> n2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            this.a.a(this.a.b(byArray2, oTSHashAddress), byArray);
            object = com.enterprisedt.bouncycastle.pqc.crypto.xmss.i.a(this.a, this.f.get(n2 - 1), this.i.get(n2 - 1), hashTreeAddress);
            object = new XMSSNode(((XMSSNode)object).getHeight() + 1, ((XMSSNode)object).getValue());
            this.f.set(n2, (XMSSNode)object);
            this.i.remove(n2 - 1);
            for (n3 = 0; n3 < n2; ++n3) {
                if (n3 < this.b - this.d) {
                    this.f.set(n3, this.c.get(n3).e());
                    continue;
                }
                this.f.set(n3, this.g.get(n3).removeFirst());
            }
            n3 = Math.min(n2, this.b - this.d);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.j + 1 + 3 * (1 << i2);
                if (n4 >= 1 << this.b) continue;
                this.c.get(i2).a(n4);
            }
        }
        for (int i3 = 0; i3 < this.b - this.d >> 1; ++i3) {
            serializable = this.b();
            if (serializable == null) continue;
            ((a)serializable).a(this.h, this.a, byArray, byArray2, oTSHashAddress);
        }
        ++this.j;
    }

    void a() {
        this.k = true;
    }

    private a b() {
        a a2 = null;
        for (a a3 : this.c) {
            if (a3.c() || !a3.d()) continue;
            if (a2 == null) {
                a2 = a3;
                continue;
            }
            if (a3.a() < a2.a()) {
                a2 = a3;
                continue;
            }
            if (a3.a() != a2.a() || a3.b() >= a2.b()) continue;
            a2 = a3;
        }
        return a2;
    }

    private void c() {
        if (this.f == null) {
            throw new IllegalStateException("authenticationPath == null");
        }
        if (this.g == null) {
            throw new IllegalStateException("retain == null");
        }
        if (this.h == null) {
            throw new IllegalStateException("stack == null");
        }
        if (this.c == null) {
            throw new IllegalStateException("treeHashInstances == null");
        }
        if (this.i == null) {
            throw new IllegalStateException("keep == null");
        }
        if (!XMSSUtil.isIndexValid(this.b, this.j)) {
            throw new IllegalStateException("index in BDS state out of bounds");
        }
    }

    protected int getTreeHeight() {
        return this.b;
    }

    protected XMSSNode getRoot() {
        return this.e;
    }

    protected List<XMSSNode> getAuthenticationPath() {
        ArrayList<XMSSNode> arrayList = new ArrayList<XMSSNode>();
        for (XMSSNode xMSSNode : this.f) {
            arrayList.add(xMSSNode);
        }
        return arrayList;
    }

    protected int getIndex() {
        return this.j;
    }

    public int getMaxIndex() {
        return this.l;
    }

    public BDS withWOTSDigest(ASN1ObjectIdentifier digestName) {
        return new BDS(this, digestName);
    }

    public BDS withMaxIndex(int maxIndex, ASN1ObjectIdentifier digestName) {
        return new BDS(this, maxIndex, digestName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.l = in.available() != 0 ? in.readInt() : (1 << this.b) - 1;
        if (this.l > (1 << this.b) - 1 || this.j > this.l + 1 || in.available() != 0) {
            throw new IOException("inconsistent BDS data detected");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.l);
    }
}

