/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.enterprisedt.bouncycastle.util.Pack;

final class OTSHashAddress
extends XMSSAddress {
    private final int a;
    private final int b;
    private final int c;

    private OTSHashAddress(Builder builder) {
        super(builder);
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
    }

    @Override
    protected byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        Pack.intToBigEndian(this.a, byArray, 16);
        Pack.intToBigEndian(this.b, byArray, 20);
        Pack.intToBigEndian(this.c, byArray, 24);
        return byArray;
    }

    protected int a() {
        return this.a;
    }

    protected int b() {
        return this.b;
    }

    protected int c() {
        return this.c;
    }

    protected static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int a = 0;
        private int b = 0;
        private int c = 0;

        protected Builder() {
            super(0);
        }

        protected Builder withOTSAddress(int val) {
            this.a = val;
            return this;
        }

        protected Builder withChainAddress(int val) {
            this.b = val;
            return this;
        }

        protected Builder withHashAddress(int val) {
            this.c = val;
            return this;
        }

        @Override
        protected XMSSAddress build() {
            return new OTSHashAddress(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

