/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import java.security.SecureRandom;

public final class XMSSMTKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private XMSSMTParameters a;
    private XMSSParameters b;
    private SecureRandom c;

    @Override
    public void init(KeyGenerationParameters param) {
        XMSSMTKeyGenerationParameters xMSSMTKeyGenerationParameters = (XMSSMTKeyGenerationParameters)param;
        this.c = xMSSMTKeyGenerationParameters.getRandom();
        this.a = xMSSMTKeyGenerationParameters.getParameters();
        this.b = this.a.getXMSSParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.a(new XMSSMTPrivateKeyParameters.Builder(this.a).build().a());
        this.b.d().a(new byte[this.a.getTreeDigestSize()], xMSSMTPrivateKeyParameters.getPublicSeed());
        int n2 = this.a.getLayers() - 1;
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n2)).build();
        BDS bDS = new BDS(this.b, xMSSMTPrivateKeyParameters.getPublicSeed(), xMSSMTPrivateKeyParameters.getSecretKeySeed(), oTSHashAddress);
        XMSSNode xMSSNode = bDS.getRoot();
        xMSSMTPrivateKeyParameters.a().a(n2, bDS);
        xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.a).withSecretKeySeed(xMSSMTPrivateKeyParameters.getSecretKeySeed()).withSecretKeyPRF(xMSSMTPrivateKeyParameters.getSecretKeyPRF()).withPublicSeed(xMSSMTPrivateKeyParameters.getPublicSeed()).withRoot(xMSSNode.getValue()).withBDSState(xMSSMTPrivateKeyParameters.a()).build();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = new XMSSMTPublicKeyParameters.Builder(this.a).withRoot(xMSSNode.getValue()).withPublicSeed(xMSSMTPrivateKeyParameters.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair(xMSSMTPublicKeyParameters, xMSSMTPrivateKeyParameters);
    }

    private XMSSMTPrivateKeyParameters a(BDSStateMap bDSStateMap) {
        int n2 = this.a.getTreeDigestSize();
        byte[] byArray = new byte[n2];
        this.c.nextBytes(byArray);
        byte[] byArray2 = new byte[n2];
        this.c.nextBytes(byArray2);
        byte[] byArray3 = new byte[n2];
        this.c.nextBytes(byArray3);
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = null;
        xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.a).withSecretKeySeed(byArray).withSecretKeyPRF(byArray2).withPublicSeed(byArray3).withBDSState(bDSStateMap).build();
        return xMSSMTPrivateKeyParameters;
    }
}

