/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Encodable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class XMSSMTSignature
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSMTParameters a;
    private final long b;
    private final byte[] c;
    private final List<XMSSReducedSignature> d;

    private XMSSMTSignature(Builder builder) {
        this.a = builder.a;
        if (this.a == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.a.getTreeDigestSize();
        byte[] byArray = builder.e;
        if (byArray != null) {
            int n3;
            int n4;
            int n5;
            int n6 = this.a.getWOTSPlus().a().c();
            int n7 = (int)Math.ceil((double)this.a.getHeight() / 8.0);
            int n8 = n7 + (n5 = n2) + (n4 = (n3 = (this.a.getHeight() / this.a.getLayers() + n6) * n2) * this.a.getLayers());
            if (byArray.length != n8) {
                throw new IllegalArgumentException("signature has wrong size");
            }
            int n9 = 0;
            this.b = XMSSUtil.bytesToXBigEndian(byArray, n9, n7);
            if (!XMSSUtil.isIndexValid(this.a.getHeight(), this.b)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n5);
            n9 += n5;
            this.d = new ArrayList<XMSSReducedSignature>();
            while (n9 < byArray.length) {
                XMSSReducedSignature xMSSReducedSignature = new XMSSReducedSignature.Builder(this.a.getXMSSParameters()).withReducedSignature(XMSSUtil.extractBytesAtOffset(byArray, n9, n3)).build();
                this.d.add(xMSSReducedSignature);
                n9 += n3;
            }
        } else {
            this.b = builder.b;
            byte[] byArray2 = builder.c;
            if (byArray2 != null) {
                if (byArray2.length != n2) {
                    throw new IllegalArgumentException("size of random needs to be equal to size of digest");
                }
                this.c = byArray2;
            } else {
                this.c = new byte[n2];
            }
            List<Object> list = builder.d;
            this.d = list != null ? list : new ArrayList<XMSSReducedSignature>();
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.toByteArray();
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.a.getTreeDigestSize();
        int n3 = this.a.getWOTSPlus().a().c();
        int n4 = (int)Math.ceil((double)this.a.getHeight() / 8.0);
        int n5 = n2;
        int n6 = (this.a.getHeight() / this.a.getLayers() + n3) * n2;
        int n7 = n6 * this.a.getLayers();
        int n8 = n4 + n5 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        byte[] byArray2 = XMSSUtil.toBytesBigEndian(this.b, n4);
        XMSSUtil.copyBytesAtOffset(byArray, byArray2, n9);
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n9 += n4);
        n9 += n5;
        for (XMSSReducedSignature xMSSReducedSignature : this.d) {
            byte[] byArray3 = xMSSReducedSignature.toByteArray();
            XMSSUtil.copyBytesAtOffset(byArray, byArray3, n9);
            n9 += n6;
        }
        return byArray;
    }

    public long getIndex() {
        return this.b;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.c);
    }

    public List<XMSSReducedSignature> getReducedSignatures() {
        return this.d;
    }

    public static class Builder {
        private final XMSSMTParameters a;
        private long b = 0L;
        private byte[] c = null;
        private List<XMSSReducedSignature> d = null;
        private byte[] e = null;

        public Builder(XMSSMTParameters params) {
            this.a = params;
        }

        public Builder withIndex(long val) {
            this.b = val;
            return this;
        }

        public Builder withRandom(byte[] val) {
            this.c = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withReducedSignatures(List<XMSSReducedSignature> val) {
            this.d = val;
            return this;
        }

        public Builder withSignature(byte[] val) {
            this.e = Arrays.clone(val);
            return this;
        }

        public XMSSMTSignature build() {
            return new XMSSMTSignature(this);
        }
    }
}

