/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import com.enterprisedt.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSSignature;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.c;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.d;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.h;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.j;
import com.enterprisedt.bouncycastle.util.Arrays;

public class XMSSSigner
implements StateAwareMessageSigner {
    private XMSSPrivateKeyParameters a;
    private XMSSPublicKeyParameters b;
    private XMSSParameters c;
    private d d;
    private c e;
    private boolean f;
    private boolean g;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.f = true;
            this.g = false;
            this.a = (XMSSPrivateKeyParameters)param;
            this.c = this.a.getParameters();
        } else {
            this.f = false;
            this.b = (XMSSPublicKeyParameters)param;
            this.c = this.b.getParameters();
        }
        this.d = this.c.d();
        this.e = this.d.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generateSignature(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.f) {
            if (this.a == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.a;
        synchronized (xMSSPrivateKeyParameters) {
            byte[] byArray;
            if (this.a.getUsagesRemaining() <= 0L) {
                throw new ExhaustedPrivateKeyException("no usages of private key remaining");
            }
            if (this.a.b().getAuthenticationPath().isEmpty()) {
                throw new IllegalStateException("not initialized");
            }
            try {
                int n2 = this.a.getIndex();
                this.g = true;
                byte[] byArray2 = this.e.d(this.a.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(n2, 32));
                byte[] byArray3 = Arrays.concatenate(byArray2, this.a.getRoot(), XMSSUtil.toBytesBigEndian(n2, this.c.getTreeDigestSize()));
                byte[] byArray4 = this.e.c(byArray3, message);
                OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
                h h2 = this.a(byArray4, oTSHashAddress);
                byArray = new XMSSSignature.Builder(this.c).withIndex(n2).withRandom(byArray2).withWOTSPlusSignature(h2).withAuthPath(this.a.b().getAuthenticationPath()).build().toByteArray();
                this.a.b().a();
                this.a.a();
            }
            catch (Throwable throwable) {
                this.a.b().a();
                this.a.a();
                throw throwable;
            }
            return byArray;
        }
    }

    public long getUsagesRemaining() {
        return this.a.getUsagesRemaining();
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        XMSSSignature xMSSSignature = new XMSSSignature.Builder(this.c).withSignature(signature).build();
        int n2 = xMSSSignature.getIndex();
        this.d.a(new byte[this.c.getTreeDigestSize()], this.b.getPublicSeed());
        byte[] byArray = Arrays.concatenate(xMSSSignature.getRandom(), this.b.getRoot(), XMSSUtil.toBytesBigEndian(n2, this.c.getTreeDigestSize()));
        byte[] byArray2 = this.e.c(byArray, message);
        int n3 = this.c.getHeight();
        int n4 = XMSSUtil.getLeafIndex(n2, n3);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        XMSSNode xMSSNode = j.a(this.d, n3, byArray2, xMSSSignature, oTSHashAddress, n4);
        return Arrays.constantTimeAreEqual(xMSSNode.getValue(), this.b.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.a;
        synchronized (xMSSPrivateKeyParameters) {
            if (this.g) {
                XMSSPrivateKeyParameters xMSSPrivateKeyParameters2 = this.a;
                this.a = null;
                return xMSSPrivateKeyParameters2;
            }
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters3 = this.a;
            if (xMSSPrivateKeyParameters3 != null) {
                this.a = this.a.getNextKey();
            }
            return xMSSPrivateKeyParameters3;
        }
    }

    private h a(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.c.getTreeDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.d.a(this.d.b(this.a.getSecretKeySeed(), oTSHashAddress), this.a.getPublicSeed());
        return this.d.a(byArray, oTSHashAddress);
    }
}

