/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru.NTRUSigningKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.DenseTernaryPolynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.Polynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.ProductFormPolynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.SparseTernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class NTRUSigningPrivateKeyParameters
extends AsymmetricKeyParameter {
    private List<Basis> b;
    private NTRUSigningPublicKeyParameters c;

    public NTRUSigningPrivateKeyParameters(byte[] b2, NTRUSigningKeyGenerationParameters params) throws IOException {
        this(new ByteArrayInputStream(b2), params);
    }

    public NTRUSigningPrivateKeyParameters(InputStream is, NTRUSigningKeyGenerationParameters params) throws IOException {
        super(true);
        this.b = new ArrayList<Basis>();
        for (int i2 = 0; i2 <= params.B; ++i2) {
            this.a(new Basis(is, params, i2 != 0));
        }
        this.c = new NTRUSigningPublicKeyParameters(is, params.getSigningParameters());
    }

    public NTRUSigningPrivateKeyParameters(List<Basis> bases, NTRUSigningPublicKeyParameters publicKey) {
        super(true);
        this.b = new ArrayList<Basis>(bases);
        this.c = publicKey;
    }

    private void a(Basis basis) {
        this.b.add(basis);
    }

    public Basis getBasis(int i2) {
        return this.b.get(i2);
    }

    public NTRUSigningPublicKeyParameters getPublicKey() {
        return this.c;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            this.b.get(i2).a(byteArrayOutputStream, i2 != 0);
        }
        byteArrayOutputStream.write(this.c.getEncoded());
        return byteArrayOutputStream.toByteArray();
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3;
        if (this.b == null) {
            return n3;
        }
        n3 += this.b.hashCode();
        for (Basis basis : this.b) {
            n3 += basis.hashCode();
        }
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = (NTRUSigningPrivateKeyParameters)obj;
        if (this.b == null != (nTRUSigningPrivateKeyParameters.b == null)) {
            return false;
        }
        if (this.b == null) {
            return true;
        }
        if (this.b.size() != nTRUSigningPrivateKeyParameters.b.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            Basis basis = this.b.get(i2);
            Basis basis2 = nTRUSigningPrivateKeyParameters.b.get(i2);
            if (!basis.f.equals(basis2.f)) {
                return false;
            }
            if (!basis.fPrime.equals(basis2.fPrime)) {
                return false;
            }
            if (i2 != 0 && !basis.h.equals(basis2.h)) {
                return false;
            }
            if (basis.a.equals(basis2.a)) continue;
            return false;
        }
        return true;
    }

    public static class Basis {
        public Polynomial f;
        public Polynomial fPrime;
        public IntegerPolynomial h;
        NTRUSigningKeyGenerationParameters a;

        protected Basis(Polynomial f2, Polynomial fPrime, IntegerPolynomial h2, NTRUSigningKeyGenerationParameters params) {
            this.f = f2;
            this.fPrime = fPrime;
            this.h = h2;
            this.a = params;
        }

        Basis(InputStream is, NTRUSigningKeyGenerationParameters params, boolean include_h) throws IOException {
            IntegerPolynomial integerPolynomial;
            int n2 = params.N;
            int n3 = params.q;
            int n4 = params.d1;
            int n5 = params.d2;
            int n6 = params.d3;
            boolean bl = params.sparse;
            this.a = params;
            if (params.polyType == 1) {
                this.f = ProductFormPolynomial.fromBinary(is, n2, n4, n5, n6 + 1, n6);
            } else {
                integerPolynomial = IntegerPolynomial.fromBinary3Tight(is, n2);
                Polynomial polynomial = this.f = bl ? new SparseTernaryPolynomial(integerPolynomial) : new DenseTernaryPolynomial(integerPolynomial);
            }
            if (params.basisType == 0) {
                integerPolynomial = IntegerPolynomial.fromBinary(is, n2, n3);
                int n7 = 0;
                while (n7 < integerPolynomial.coeffs.length) {
                    int n8 = n7++;
                    integerPolynomial.coeffs[n8] = integerPolynomial.coeffs[n8] - n3 / 2;
                }
                this.fPrime = integerPolynomial;
            } else {
                this.fPrime = params.polyType == 1 ? ProductFormPolynomial.fromBinary(is, n2, n4, n5, n6 + 1, n6) : IntegerPolynomial.fromBinary3Tight(is, n2);
            }
            if (include_h) {
                this.h = IntegerPolynomial.fromBinary(is, n2, n3);
            }
        }

        void a(OutputStream outputStream, boolean bl) throws IOException {
            int n2 = this.a.q;
            outputStream.write(this.a(this.f));
            if (this.a.basisType == 0) {
                IntegerPolynomial integerPolynomial = this.fPrime.toIntegerPolynomial();
                int n3 = 0;
                while (n3 < integerPolynomial.coeffs.length) {
                    int n4 = n3++;
                    integerPolynomial.coeffs[n4] = integerPolynomial.coeffs[n4] + n2 / 2;
                }
                outputStream.write(integerPolynomial.toBinary(n2));
            } else {
                outputStream.write(this.a(this.fPrime));
            }
            if (bl) {
                outputStream.write(this.h.toBinary(n2));
            }
        }

        private byte[] a(Polynomial polynomial) {
            if (polynomial instanceof ProductFormPolynomial) {
                return ((ProductFormPolynomial)polynomial).toBinary();
            }
            return polynomial.toIntegerPolynomial().toBinary3Tight();
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.f == null ? 0 : this.f.hashCode());
            n3 = 31 * n3 + (this.fPrime == null ? 0 : this.fPrime.hashCode());
            n3 = 31 * n3 + (this.h == null ? 0 : this.h.hashCode());
            n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
            return n3;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Basis)) {
                return false;
            }
            Basis basis = (Basis)obj;
            if (this.f == null ? basis.f != null : !this.f.equals(basis.f)) {
                return false;
            }
            if (this.fPrime == null ? basis.fPrime != null : !this.fPrime.equals(basis.fPrime)) {
                return false;
            }
            if (this.h == null ? basis.h != null : !this.h.equals(basis.h)) {
                return false;
            }
            return !(this.a == null ? basis.a != null : !this.a.equals(basis.a));
        }
    }
}

