/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra;

import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.LittleEndianConversions;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialRingGF2;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class GF2mField {
    private int a = 0;
    private int b;

    public GF2mField(int degree) {
        if (degree >= 32) {
            throw new IllegalArgumentException(" Error: the degree of field is too large ");
        }
        if (degree < 1) {
            throw new IllegalArgumentException(" Error: the degree of field is non-positive ");
        }
        this.a = degree;
        this.b = PolynomialRingGF2.getIrreduciblePolynomial(degree);
    }

    public GF2mField(int degree, int poly) {
        if (degree != PolynomialRingGF2.degree(poly)) {
            throw new IllegalArgumentException(" Error: the degree is not correct");
        }
        if (!PolynomialRingGF2.isIrreducible(poly)) {
            throw new IllegalArgumentException(" Error: given polynomial is reducible");
        }
        this.a = degree;
        this.b = poly;
    }

    public GF2mField(byte[] enc) {
        if (enc.length != 4) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.b = LittleEndianConversions.OS2IP(enc);
        if (!PolynomialRingGF2.isIrreducible(this.b)) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.a = PolynomialRingGF2.degree(this.b);
    }

    public GF2mField(GF2mField field) {
        this.a = field.a;
        this.b = field.b;
    }

    public int getDegree() {
        return this.a;
    }

    public int getPolynomial() {
        return this.b;
    }

    public byte[] getEncoded() {
        return LittleEndianConversions.I2OSP(this.b);
    }

    public int add(int a2, int b2) {
        return a2 ^ b2;
    }

    public int mult(int a2, int b2) {
        return PolynomialRingGF2.modMultiply(a2, b2, this.b);
    }

    public int exp(int a2, int k2) {
        if (k2 == 0) {
            return 1;
        }
        if (a2 == 0) {
            return 0;
        }
        if (a2 == 1) {
            return 1;
        }
        int n2 = 1;
        if (k2 < 0) {
            a2 = this.inverse(a2);
            k2 = -k2;
        }
        while (k2 != 0) {
            if ((k2 & 1) == 1) {
                n2 = this.mult(n2, a2);
            }
            a2 = this.mult(a2, a2);
            k2 >>>= 1;
        }
        return n2;
    }

    public int inverse(int a2) {
        int n2 = (1 << this.a) - 2;
        return this.exp(a2, n2);
    }

    public int sqRoot(int a2) {
        for (int i2 = 1; i2 < this.a; ++i2) {
            a2 = this.mult(a2, a2);
        }
        return a2;
    }

    public int getRandomElement(SecureRandom sr) {
        int n2 = RandUtils.a(sr, 1 << this.a);
        return n2;
    }

    public int getRandomNonZeroElement() {
        return this.getRandomNonZeroElement(CryptoServicesRegistrar.getSecureRandom());
    }

    public int getRandomNonZeroElement(SecureRandom sr) {
        int n2;
        int n3 = 0x100000;
        int n4 = RandUtils.a(sr, 1 << this.a);
        for (n2 = 0; n4 == 0 && n2 < n3; ++n2) {
            n4 = RandUtils.a(sr, 1 << this.a);
        }
        if (n2 == n3) {
            n4 = 1;
        }
        return n4;
    }

    public boolean isElementOfThisField(int e2) {
        if (this.a == 31) {
            return e2 >= 0;
        }
        return e2 >= 0 && e2 < 1 << this.a;
    }

    public String elementToStr(int a2) {
        String string = "";
        for (int i2 = 0; i2 < this.a; ++i2) {
            string = ((byte)a2 & 1) == 0 ? "0" + string : "1" + string;
            a2 >>>= 1;
        }
        return string;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2mField)) {
            return false;
        }
        GF2mField gF2mField = (GF2mField)other;
        return this.a == gF2mField.a && this.b == gF2mField.b;
    }

    public int hashCode() {
        return this.b;
    }

    public String toString() {
        String string = "Finite Field GF(2^" + this.a + ") = GF(2)[X]/<" + GF2mField.a(this.b) + "> ";
        return string;
    }

    private static String a(int n2) {
        String string = "";
        if (n2 == 0) {
            string = "0";
        } else {
            byte by = (byte)(n2 & 1);
            if (by == 1) {
                string = "1";
            }
            n2 >>>= 1;
            int n3 = 1;
            while (n2 != 0) {
                by = (byte)(n2 & 1);
                if (by == 1) {
                    string = string + "+x^" + n3;
                }
                n2 >>>= 1;
                ++n3;
            }
        }
        return string;
    }
}

