/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra;

import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Polynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomialElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomialField;
import java.security.SecureRandom;
import java.util.Vector;

public abstract class GF2nField {
    protected final SecureRandom random;
    protected int mDegree;
    protected GF2Polynomial fieldPolynomial;
    protected Vector fields;
    protected Vector matrices;

    protected GF2nField(SecureRandom random) {
        this.random = random;
    }

    public final int getDegree() {
        return this.mDegree;
    }

    public final GF2Polynomial getFieldPolynomial() {
        if (this.fieldPolynomial == null) {
            this.computeFieldPolynomial();
        }
        return new GF2Polynomial(this.fieldPolynomial);
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nField)) {
            return false;
        }
        GF2nField gF2nField = (GF2nField)other;
        if (gF2nField.mDegree != this.mDegree) {
            return false;
        }
        if (!this.fieldPolynomial.equals(gF2nField.fieldPolynomial)) {
            return false;
        }
        if (this instanceof GF2nPolynomialField && !(gF2nField instanceof GF2nPolynomialField)) {
            return false;
        }
        return !(this instanceof GF2nONBField) || gF2nField instanceof GF2nONBField;
    }

    public int hashCode() {
        return this.mDegree + this.fieldPolynomial.hashCode();
    }

    protected abstract GF2nElement getRandomRoot(GF2Polynomial var1);

    protected abstract void computeCOBMatrix(GF2nField var1);

    protected abstract void computeFieldPolynomial();

    protected final GF2Polynomial[] invertMatrix(GF2Polynomial[] matrix) {
        int n2;
        int n3;
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[matrix.length];
        GF2Polynomial[] gF2PolynomialArray2 = new GF2Polynomial[matrix.length];
        for (n3 = 0; n3 < this.mDegree; ++n3) {
            gF2PolynomialArray[n3] = new GF2Polynomial(matrix[n3]);
            gF2PolynomialArray2[n3] = new GF2Polynomial(this.mDegree);
            gF2PolynomialArray2[n3].setBit(this.mDegree - 1 - n3);
        }
        for (n3 = 0; n3 < this.mDegree - 1; ++n3) {
            for (n2 = n3; n2 < this.mDegree && !gF2PolynomialArray[n2].testBit(this.mDegree - 1 - n3); ++n2) {
            }
            if (n2 >= this.mDegree) {
                throw new RuntimeException("GF2nField.invertMatrix: Matrix cannot be inverted!");
            }
            if (n3 != n2) {
                GF2Polynomial gF2Polynomial = gF2PolynomialArray[n3];
                gF2PolynomialArray[n3] = gF2PolynomialArray[n2];
                gF2PolynomialArray[n2] = gF2Polynomial;
                gF2Polynomial = gF2PolynomialArray2[n3];
                gF2PolynomialArray2[n3] = gF2PolynomialArray2[n2];
                gF2PolynomialArray2[n2] = gF2Polynomial;
            }
            for (n2 = n3 + 1; n2 < this.mDegree; ++n2) {
                if (!gF2PolynomialArray[n2].testBit(this.mDegree - 1 - n3)) continue;
                gF2PolynomialArray[n2].addToThis(gF2PolynomialArray[n3]);
                gF2PolynomialArray2[n2].addToThis(gF2PolynomialArray2[n3]);
            }
        }
        for (n3 = this.mDegree - 1; n3 > 0; --n3) {
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                if (!gF2PolynomialArray[n2].testBit(this.mDegree - 1 - n3)) continue;
                gF2PolynomialArray[n2].addToThis(gF2PolynomialArray[n3]);
                gF2PolynomialArray2[n2].addToThis(gF2PolynomialArray2[n3]);
            }
        }
        return gF2PolynomialArray2;
    }

    public final GF2nElement convert(GF2nElement elem, GF2nField basis) throws RuntimeException {
        if (basis == this) {
            return (GF2nElement)elem.clone();
        }
        if (this.fieldPolynomial.equals(basis.fieldPolynomial)) {
            return (GF2nElement)elem.clone();
        }
        if (this.mDegree != basis.mDegree) {
            throw new RuntimeException("GF2nField.convert: B1 has a different degree and thus cannot be coverted to!");
        }
        int n2 = this.fields.indexOf(basis);
        if (n2 == -1) {
            this.computeCOBMatrix(basis);
            n2 = this.fields.indexOf(basis);
        }
        GF2Polynomial[] gF2PolynomialArray = (GF2Polynomial[])this.matrices.elementAt(n2);
        GF2nElement gF2nElement = (GF2nElement)elem.clone();
        if (gF2nElement instanceof GF2nONBElement) {
            ((GF2nONBElement)gF2nElement).b();
        }
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.mDegree, gF2nElement.toFlexiBigInt());
        gF2Polynomial.expandN(this.mDegree);
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.mDegree);
        for (n2 = 0; n2 < this.mDegree; ++n2) {
            if (!gF2Polynomial.vectorMult(gF2PolynomialArray[n2])) continue;
            gF2Polynomial2.setBit(this.mDegree - 1 - n2);
        }
        if (basis instanceof GF2nPolynomialField) {
            return new GF2nPolynomialElement((GF2nPolynomialField)basis, gF2Polynomial2);
        }
        if (basis instanceof GF2nONBField) {
            GF2nONBElement gF2nONBElement = new GF2nONBElement((GF2nONBField)basis, gF2Polynomial2.toFlexiBigInt());
            gF2nONBElement.b();
            return gF2nONBElement;
        }
        throw new RuntimeException("GF2nField.convert: B1 must be an instance of GF2nPolynomialField or GF2nONBField!");
    }
}

