/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra;

import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.IntUtils;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.IntegerFunctions;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.LittleEndianConversions;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.RandUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class Permutation {
    private int[] a;

    public Permutation(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.a = new int[n2];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.a[i2] = i2;
        }
    }

    public Permutation(int[] perm) {
        if (!this.a(perm)) {
            throw new IllegalArgumentException("array is not a permutation vector");
        }
        this.a = IntUtils.clone(perm);
    }

    public Permutation(byte[] enc) {
        int n2;
        if (enc.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n3 = LittleEndianConversions.OS2IP(enc, 0);
        if (enc.length != 4 + n3 * (n2 = IntegerFunctions.ceilLog256(n3 - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.a = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.a[i2] = LittleEndianConversions.OS2IP(enc, 4 + i2 * n2, n2);
        }
        if (!this.a(this.a)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public Permutation(int n2, SecureRandom sr) {
        int n3;
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.a = new int[n2];
        int[] nArray = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = n3;
        }
        n3 = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = RandUtils.a(sr, n3);
            this.a[i2] = nArray[n4];
            nArray[n4] = nArray[--n3];
        }
    }

    public byte[] getEncoded() {
        int n2 = this.a.length;
        int n3 = IntegerFunctions.ceilLog256(n2 - 1);
        byte[] byArray = new byte[4 + n2 * n3];
        LittleEndianConversions.I2OSP(n2, byArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            LittleEndianConversions.I2OSP(this.a[i2], byArray, 4 + i2 * n3, n3);
        }
        return byArray;
    }

    public int[] getVector() {
        return IntUtils.clone(this.a);
    }

    public Permutation computeInverse() {
        Permutation permutation = new Permutation(this.a.length);
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            permutation.a[this.a[i2]] = i2;
        }
        return permutation;
    }

    public Permutation rightMultiply(Permutation p2) {
        if (p2.a.length != this.a.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        Permutation permutation = new Permutation(this.a.length);
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            permutation.a[i2] = this.a[p2.a[i2]];
        }
        return permutation;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Permutation)) {
            return false;
        }
        Permutation permutation = (Permutation)other;
        return IntUtils.equals(this.a, permutation.a);
    }

    public String toString() {
        String string = "[" + this.a[0];
        for (int i2 = 1; i2 < this.a.length; ++i2) {
            string = string + ", " + this.a[i2];
        }
        string = string + "]";
        return string;
    }

    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    private boolean a(int[] nArray) {
        int n2 = nArray.length;
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] < 0 || nArray[i2] >= n2 || blArray[nArray[i2]]) {
                return false;
            }
            blArray[nArray[i2]] = true;
        }
        return true;
    }
}

