/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsPeer;
import com.enterprisedt.bouncycastle.tls.CertificateStatusRequest;
import com.enterprisedt.bouncycastle.tls.DefaultTlsDHGroupVerifier;
import com.enterprisedt.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.OCSPStatusRequest;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsClient;
import com.enterprisedt.bouncycastle.tls.TlsClientContext;
import com.enterprisedt.bouncycastle.tls.TlsDHGroupVerifier;
import com.enterprisedt.bouncycastle.tls.TlsECCUtils;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsPSK;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentity;
import com.enterprisedt.bouncycastle.tls.TlsSRPConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsSRPIdentity;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsClientContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;
    protected Vector supportedSignatureAlgorithmsCert;

    public AbstractTlsClient(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        switch (extensionType) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(extensionData);
                return true;
            }
            case 11: {
                TlsExtensionsUtils.readSupportedPointFormatsExtension(extensionData);
                return true;
            }
        }
        return false;
    }

    protected Vector getNamedGroupRoles() {
        Vector vector = TlsUtils.getNamedGroupRoles(this.getCipherSuites());
        Vector vector2 = this.supportedSignatureAlgorithms;
        Vector vector3 = this.supportedSignatureAlgorithmsCert;
        if (null == vector2 || TlsUtils.containsAnySignatureAlgorithm(vector2, (short)3) || null != vector3 && TlsUtils.containsAnySignatureAlgorithm(vector3, (short)3)) {
            TlsUtils.addToSet(vector, 3);
        }
        return vector;
    }

    protected void checkForUnexpectedServerExtension(Hashtable serverExtensions, Integer extensionType) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(serverExtensions, extensionType);
        if (byArray != null && !this.allowUnexpectedServerExtension(extensionType, byArray)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected byte[] getNewConnectionID() {
        return null;
    }

    @Override
    public TlsPSKIdentity getPSKIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsSRPIdentity getSRPIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new DefaultTlsDHGroupVerifier();
    }

    @Override
    public TlsSRPConfigVerifier getSRPConfigVerifier() {
        return new DefaultTlsSRPConfigVerifier();
    }

    protected Vector getCertificateAuthorities() {
        return null;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getMultiCertStatusRequest() {
        return null;
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected Vector getSupportedGroups(Vector namedGroupRoles) {
        TlsCrypto tlsCrypto = this.getCrypto();
        Vector vector = new Vector();
        if (namedGroupRoles.contains(Integers.valueOf(2))) {
            TlsUtils.addIfSupported(vector, tlsCrypto, new int[]{29, 30});
        }
        if (namedGroupRoles.contains(Integers.valueOf(2)) || namedGroupRoles.contains(Integers.valueOf(3))) {
            TlsUtils.addIfSupported(vector, tlsCrypto, new int[]{23, 24});
        }
        if (namedGroupRoles.contains(Integers.valueOf(1))) {
            TlsUtils.addIfSupported(vector, tlsCrypto, new int[]{256, 257, 258});
        }
        return vector;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    protected Vector getSupportedSignatureAlgorithmsCert() {
        return null;
    }

    protected Vector getTrustedCAIndication() {
        return null;
    }

    protected short[] getAllowedClientCertificateTypes() {
        return null;
    }

    protected short[] getAllowedServerCertificateTypes() {
        return null;
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.supportedGroups = null;
        this.supportedSignatureAlgorithms = null;
        this.supportedSignatureAlgorithmsCert = null;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public Vector getExternalPSKs() {
        return null;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Object[] objectArray;
        Vector vector;
        Vector vector2;
        Object object;
        Vector vector3;
        Object object2;
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object3 = this.getProtocolVersions();
        for (int i2 = 0; i2 < ((ProtocolVersion[])object3).length; ++i2) {
            object2 = object3[i2];
            if (TlsUtils.isTLSv13((ProtocolVersion)object2)) {
                bl = true;
            } else {
                bl2 = true;
            }
            bl3 |= ProtocolVersion.DTLSv12.equals((ProtocolVersion)object2);
        }
        object3 = this.getProtocolNames();
        if (object3 != null) {
            TlsExtensionsUtils.addALPNExtensionClient(hashtable, (Vector)object3);
        }
        if ((vector3 = this.getSNIServerNames()) != null) {
            TlsExtensionsUtils.addServerNameExtensionClient(hashtable, vector3);
        }
        if ((object2 = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(hashtable, (CertificateStatusRequest)object2);
        }
        if (bl && (object = this.getCertificateAuthorities()) != null) {
            TlsExtensionsUtils.addCertificateAuthoritiesExtension(hashtable, (Vector)object);
        }
        if (bl2) {
            TlsExtensionsUtils.addEncryptThenMACExtension(hashtable);
            object = this.getMultiCertStatusRequest();
            if (object != null) {
                TlsExtensionsUtils.addStatusRequestV2Extension(hashtable, (Vector)object);
            }
            if ((vector2 = this.getTrustedCAIndication()) != null) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionClient(hashtable, vector2);
            }
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)(object = this.context.getClientVersion()))) {
            vector2 = this.getSupportedSignatureAlgorithms();
            if (null != vector2 && !vector2.isEmpty()) {
                this.supportedSignatureAlgorithms = vector2;
                TlsExtensionsUtils.addSignatureAlgorithmsExtension(hashtable, vector2);
            }
            if (null != (vector = this.getSupportedSignatureAlgorithmsCert()) && !vector.isEmpty()) {
                this.supportedSignatureAlgorithmsCert = vector;
                TlsExtensionsUtils.addSignatureAlgorithmsCertExtension(hashtable, vector);
            }
        }
        if ((vector = this.getSupportedGroups(vector2 = this.getNamedGroupRoles())) != null && !vector.isEmpty()) {
            this.supportedGroups = vector;
            TlsExtensionsUtils.addSupportedGroupsExtension(hashtable, vector);
        }
        if (bl2 && (vector2.contains(Integers.valueOf(2)) || vector2.contains(Integers.valueOf(3)))) {
            TlsExtensionsUtils.addSupportedPointFormatsExtension(hashtable, new short[]{0});
        }
        if ((objectArray = this.getAllowedClientCertificateTypes()) != null && TlsUtils.b(objectArray, 0, objectArray.length, (short)0)) {
            TlsExtensionsUtils.addClientCertificateTypeExtensionClient(hashtable, objectArray);
        }
        if ((objectArray = this.getAllowedServerCertificateTypes()) != null && TlsUtils.b(objectArray, 0, objectArray.length, (short)0)) {
            TlsExtensionsUtils.addServerCertificateTypeExtensionClient(hashtable, objectArray);
        }
        if (bl3 && (objectArray = (Object[])this.getNewConnectionID()) != null) {
            TlsExtensionsUtils.addConnectionIDExtension(hashtable, (byte[])objectArray);
        }
        return hashtable;
    }

    @Override
    public Vector getEarlyKeyShareGroups() {
        if (null == this.supportedGroups || this.supportedGroups.isEmpty()) {
            return null;
        }
        if (this.supportedGroups.contains(Integers.valueOf(29))) {
            return TlsUtils.vectorOfOne(Integers.valueOf(29));
        }
        if (this.supportedGroups.contains(Integers.valueOf(23))) {
            return TlsUtils.vectorOfOne(Integers.valueOf(23));
        }
        return TlsUtils.vectorOfOne(this.supportedGroups.elementAt(0));
    }

    @Override
    public boolean shouldUseCompatibilityMode() {
        return true;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
    }

    @Override
    public void notifySessionToResume(TlsSession session) {
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
    }

    @Override
    public void notifySelectedPSK(TlsPSK selectedPSK) throws IOException {
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (null == serverExtensions) {
            return;
        }
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        boolean bl = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (!bl) {
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_signature_algorithms_cert);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_supported_groups);
            int n2 = securityParameters.getCipherSuite();
            if (TlsECCUtils.isECCCipherSuite(n2)) {
                TlsExtensionsUtils.getSupportedPointFormatsExtension(serverExtensions);
            } else {
                this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_padding);
        }
    }

    @Override
    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

