/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int keyExchange) {
        this.keyExchange = keyExchange;
    }

    @Override
    public void init(TlsContext context) {
        this.context = context;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public short[] getClientCertificateTypes() {
        return null;
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean requiresCertificateVerify() {
        return true;
    }
}

