/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class CertificateRequest {
    protected final byte[] certificateRequestContext;
    protected final short[] certificateTypes;
    protected final Vector supportedSignatureAlgorithms;
    protected final Vector supportedSignatureAlgorithmsCert;
    protected final Vector certificateAuthorities;

    private static Vector a(Vector vector, short s2) throws IOException {
        if (null == vector) {
            throw new TlsFatalAlert(s2, "'signature_algorithms' is required");
        }
        return vector;
    }

    public CertificateRequest(short[] certificateTypes, Vector supportedSignatureAlgorithms, Vector certificateAuthorities) {
        this(null, certificateTypes, supportedSignatureAlgorithms, null, certificateAuthorities);
    }

    public CertificateRequest(byte[] certificateRequestContext, Vector supportedSignatureAlgorithms, Vector supportedSignatureAlgorithmsCert, Vector certificateAuthorities) throws IOException {
        this(certificateRequestContext, null, CertificateRequest.a(supportedSignatureAlgorithms, (short)80), supportedSignatureAlgorithmsCert, certificateAuthorities);
    }

    private CertificateRequest(byte[] certificateRequestContext, short[] certificateTypes, Vector supportedSignatureAlgorithms, Vector supportedSignatureAlgorithmsCert, Vector certificateAuthorities) {
        if (null != certificateRequestContext && !TlsUtils.isValidUint8(certificateRequestContext.length)) {
            throw new IllegalArgumentException("'certificateRequestContext' cannot be longer than 255");
        }
        if (!(null == certificateTypes || certificateTypes.length >= 1 && TlsUtils.isValidUint8(certificateTypes.length))) {
            throw new IllegalArgumentException("'certificateTypes' should have length from 1 to 255");
        }
        this.certificateRequestContext = TlsUtils.clone(certificateRequestContext);
        this.certificateTypes = certificateTypes;
        this.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
        this.supportedSignatureAlgorithmsCert = supportedSignatureAlgorithmsCert;
        this.certificateAuthorities = certificateAuthorities;
    }

    public byte[] getCertificateRequestContext() {
        return TlsUtils.clone(this.certificateRequestContext);
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public Vector getSupportedSignatureAlgorithmsCert() {
        return this.supportedSignatureAlgorithmsCert;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public boolean hasCertificateRequestContext(byte[] certificateRequestContext) {
        return Arrays.areEqual(this.certificateRequestContext, certificateRequestContext);
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        ProtocolVersion protocolVersion = context.getServerVersion();
        boolean bl = TlsUtils.isTLSv12(protocolVersion);
        boolean bl2 = TlsUtils.isTLSv13(protocolVersion);
        if (bl2 != (null != this.certificateRequestContext) || bl2 != (null == this.certificateTypes) || bl != (null != this.supportedSignatureAlgorithms) || !bl2 && null != this.supportedSignatureAlgorithmsCert) {
            throw new IllegalStateException();
        }
        if (bl2) {
            TlsUtils.writeOpaque8(this.certificateRequestContext, output);
            Hashtable hashtable = new Hashtable();
            TlsExtensionsUtils.addSignatureAlgorithmsExtension(hashtable, this.supportedSignatureAlgorithms);
            if (null != this.supportedSignatureAlgorithmsCert) {
                TlsExtensionsUtils.addSignatureAlgorithmsCertExtension(hashtable, this.supportedSignatureAlgorithmsCert);
            }
            if (null != this.certificateAuthorities) {
                TlsExtensionsUtils.addCertificateAuthoritiesExtension(hashtable, this.certificateAuthorities);
            }
            byte[] byArray = TlsProtocol.writeExtensionsData(hashtable);
            TlsUtils.writeOpaque16(byArray, output);
            return;
        }
        TlsUtils.writeUint8ArrayWithUint8Length(this.certificateTypes, output);
        if (bl) {
            TlsUtils.encodeSupportedSignatureAlgorithms(this.supportedSignatureAlgorithms, output);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16(0, output);
        } else {
            Object object;
            int n2;
            Vector<byte[]> vector = new Vector<byte[]>(this.certificateAuthorities.size());
            int n3 = 0;
            for (n2 = 0; n2 < this.certificateAuthorities.size(); ++n2) {
                object = (X500Name)this.certificateAuthorities.elementAt(n2);
                byte[] byArray = ((ASN1Object)object).getEncoded("DER");
                vector.addElement(byArray);
                n3 += byArray.length + 2;
            }
            TlsUtils.checkUint16(n3);
            TlsUtils.writeUint16(n3, output);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = (byte[])vector.elementAt(n2);
                TlsUtils.writeOpaque16((byte[])object, output);
            }
        }
    }

    public static CertificateRequest parse(TlsContext context, InputStream input) throws IOException {
        ProtocolVersion protocolVersion = context.getServerVersion();
        boolean bl = TlsUtils.isTLSv13(protocolVersion);
        if (bl) {
            byte[] byArray = TlsUtils.readOpaque8(input);
            byte[] byArray2 = TlsUtils.readOpaque16(input);
            Hashtable hashtable = TlsProtocol.readExtensionsData13(13, byArray2);
            Vector vector = CertificateRequest.a(TlsExtensionsUtils.getSignatureAlgorithmsExtension(hashtable), (short)109);
            Vector vector2 = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(hashtable);
            Vector vector3 = TlsExtensionsUtils.getCertificateAuthoritiesExtension(hashtable);
            return new CertificateRequest(byArray, vector, vector2, vector3);
        }
        boolean bl2 = TlsUtils.isTLSv12(protocolVersion);
        short[] sArray = TlsUtils.readUint8ArrayWithUint8Length(input, 1);
        Vector vector = null;
        if (bl2) {
            vector = TlsUtils.parseSupportedSignatureAlgorithms(input);
        }
        Vector<X500Name> vector4 = null;
        byte[] byArray = TlsUtils.readOpaque16(input);
        if (byArray.length > 0) {
            vector4 = new Vector<X500Name>();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            do {
                byte[] byArray3 = TlsUtils.readOpaque16(byteArrayInputStream, 1);
                ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray3);
                X500Name x500Name = X500Name.getInstance(aSN1Primitive);
                TlsUtils.requireDEREncoding(x500Name, byArray3);
                vector4.addElement(x500Name);
            } while (byteArrayInputStream.available() > 0);
        }
        return new CertificateRequest(sArray, vector, vector4);
    }
}

