/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.OCSPStatusRequest;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertificateStatusRequest {
    protected short statusType;
    protected Object request;

    public CertificateStatusRequest(short statusType, Object request) {
        if (!CertificateStatusRequest.isCorrectType(statusType, request)) {
            throw new IllegalArgumentException("'request' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.request = request;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getRequest() {
        return this.request;
    }

    public OCSPStatusRequest getOCSPStatusRequest() {
        if (!CertificateStatusRequest.isCorrectType((short)1, this.request)) {
            throw new IllegalStateException("'request' is not an OCSPStatusRequest");
        }
        return (OCSPStatusRequest)this.request;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        switch (this.statusType) {
            case 1: {
                ((OCSPStatusRequest)this.request).encode(output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatusRequest parse(InputStream input) throws IOException {
        OCSPStatusRequest oCSPStatusRequest;
        short s2 = TlsUtils.readUint8(input);
        switch (s2) {
            case 1: {
                oCSPStatusRequest = OCSPStatusRequest.parse(input);
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatusRequest(s2, oCSPStatusRequest);
    }

    protected static boolean isCorrectType(short statusType, Object request) {
        switch (statusType) {
            case 1: {
                return request instanceof OCSPStatusRequest;
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }
}

