/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.ClientHello;
import com.enterprisedt.bouncycastle.tls.DTLSProtocol;
import com.enterprisedt.bouncycastle.tls.DTLSTransport;
import com.enterprisedt.bouncycastle.tls.DatagramTransport;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.HeartbeatExtension;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.OfferedPsks;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.ServerHello;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsClient;
import com.enterprisedt.bouncycastle.tls.TlsClientContext;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHeartbeat;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamSigner;
import com.enterprisedt.bouncycastle.tls.e;
import com.enterprisedt.bouncycastle.tls.f;
import com.enterprisedt.bouncycastle.tls.o;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSTransport connect(TlsClient client, DatagramTransport transport) throws IOException {
        if (client == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        o o2 = new o(client.getCrypto());
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.a = client;
        clientHandshakeState.b = o2;
        client.init(o2);
        o2.a(client);
        SecurityParameters securityParameters = o2.getSecurityParametersHandshake();
        securityParameters.E = client.shouldUseExtendedPadding();
        e e2 = new e(o2, client, transport);
        client.notifyCloseHandle(e2);
        try {
            DTLSTransport dTLSTransport = this.clientHandshake(clientHandshakeState, e2);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, e2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, e2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, e2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.a();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState state, e recordLayer, short alertDescription) {
        recordLayer.a(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState state, e recordLayer) throws IOException {
        byte[] byArray;
        Object object;
        Object object2;
        TlsClient tlsClient = state.a;
        o o2 = state.b;
        SecurityParameters securityParameters = o2.getSecurityParametersHandshake();
        f f2 = new f(o2, recordLayer, tlsClient.getHandshakeTimeoutMillis(), tlsClient.getHandshakeResendTimeMillis(), null);
        byte[] byArray2 = this.generateClientHello(state);
        recordLayer.b(ProtocolVersion.DTLSv10);
        f2.a((short)1, byArray2);
        f.a a2 = f2.d();
        while (a2.b() == 3) {
            object2 = this.processHelloVerifyRequest(state, a2.c());
            object = DTLSClientProtocol.patchClientHelloWithCookie(byArray2, (byte[])object2);
            f2.a();
            f2.a((short)1, (byte[])object);
            a2 = f2.d();
        }
        if (a2.b() != 2) {
            throw new TlsFatalAlert(10);
        }
        object2 = recordLayer.c();
        this.reportServerVersion(state, (ProtocolVersion)object2);
        recordLayer.b((ProtocolVersion)object2);
        this.processServerHello(state, a2.c());
        DTLSClientProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.getMaxFragmentLength());
        f2.b().notifyPRFDetermined();
        if (securityParameters.isResumedSession()) {
            securityParameters.r = state.e;
            recordLayer.a(TlsUtils.c(o2));
            securityParameters.Y = TlsUtils.a((TlsContext)o2, f2.b(), true);
            this.processFinished(f2.a((short)20), securityParameters.getPeerVerifyData());
            securityParameters.X = TlsUtils.a((TlsContext)o2, f2.b(), false);
            f2.a((short)20, securityParameters.getLocalVerifyData());
            f2.e();
            if (securityParameters.isExtendedMasterSecret()) {
                securityParameters.B = securityParameters.getPeerVerifyData();
            }
            securityParameters.R = state.d.getLocalCertificate();
            securityParameters.S = state.d.getPeerCertificate();
            securityParameters.y = state.d.getPSKIdentity();
            securityParameters.z = state.d.getSRPIdentity();
            o2.a(tlsClient, state.c);
            recordLayer.a(state.q, 1 == state.r);
            return new DTLSTransport(recordLayer);
        }
        this.invalidateSession(state);
        state.c = TlsUtils.importSession(securityParameters.getSessionID(), null);
        a2 = f2.d();
        if (a2.b() == 23) {
            this.processServerSupplementalData(state, a2.c());
            a2 = f2.d();
        } else {
            tlsClient.processServerSupplementalData(null);
        }
        state.m = TlsUtils.a((TlsClientContext)o2, tlsClient);
        if (a2.b() == 11) {
            this.processServerCertificate(state, a2.c());
            a2 = f2.d();
        } else {
            state.n = null;
        }
        if (a2.b() == 22) {
            if (securityParameters.getStatusRequestVersion() < 1) {
                throw new TlsFatalAlert(10);
            }
            this.processCertificateStatus(state, a2.c());
            a2 = f2.d();
        }
        TlsUtils.a(o2, state.o, state.m, state.n, state.h, state.i);
        if (a2.b() == 12) {
            this.processServerKeyExchange(state, a2.c());
            a2 = f2.d();
        } else {
            state.m.skipServerKeyExchange();
        }
        if (a2.b() == 13) {
            this.processCertificateRequest(state, a2.c());
            TlsUtils.a(securityParameters, state.p);
            a2 = f2.d();
        }
        if (a2.b() == 14) {
            if (a2.c().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        object2 = null;
        object = null;
        Certificate certificate = null;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        TlsStreamSigner tlsStreamSigner = null;
        if (state.p != null && (object2 = (Object)TlsUtils.a(state.n, state.p)) != null) {
            certificate = object2.getCertificate();
            if (object2 instanceof TlsCredentialedSigner) {
                object = (TlsCredentialedSigner)object2;
                signatureAndHashAlgorithm = TlsUtils.a(securityParameters.getNegotiatedVersion(), (TlsCredentialedSigner)object);
                tlsStreamSigner = object.getStreamSigner();
                if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion())) {
                    TlsUtils.a(securityParameters.getServerSigAlgs(), signatureAndHashAlgorithm, (short)80);
                    if (tlsStreamSigner == null) {
                        TlsUtils.a(f2.b(), signatureAndHashAlgorithm);
                    }
                }
                if (tlsStreamSigner != null) {
                    f2.b().forceBuffering();
                }
            }
        }
        f2.b().sealHashAlgorithms();
        if (object2 == null) {
            state.m.skipClientCredentials();
        } else {
            state.m.processClientCredentials((TlsCredentials)object2);
        }
        Vector vector = tlsClient.getClientSupplementalData();
        if (vector != null) {
            byArray = DTLSClientProtocol.generateSupplementalData(vector);
            f2.a((short)23, byArray);
        }
        if (null != state.p) {
            DTLSClientProtocol.sendCertificateMessage(o2, f2, certificate, null);
        }
        byArray = this.generateClientKeyExchange(state);
        f2.a((short)16, byArray);
        securityParameters.w = TlsUtils.a(f2.b());
        TlsProtocol.establishMasterSecret(o2, state.m);
        recordLayer.a(TlsUtils.c(o2));
        if (object != null) {
            DigitallySigned digitallySigned = TlsUtils.a(o2, (TlsCredentialedSigner)object, signatureAndHashAlgorithm, tlsStreamSigner, f2.b());
            byte[] byArray3 = this.generateCertificateVerify(state, digitallySigned);
            f2.a((short)15, byArray3);
        }
        f2.c();
        securityParameters.X = TlsUtils.a((TlsContext)o2, f2.b(), false);
        f2.a((short)20, securityParameters.getLocalVerifyData());
        if (state.j) {
            a2 = f2.d();
            if (a2.b() == 4) {
                securityParameters.x = TlsUtils.EMPTY_BYTES;
                this.invalidateSession(state);
                state.c = TlsUtils.importSession(securityParameters.getSessionID(), null);
                this.processNewSessionTicket(state, a2.c());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        securityParameters.Y = TlsUtils.a((TlsContext)o2, f2.b(), true);
        this.processFinished(f2.a((short)20), securityParameters.getPeerVerifyData());
        f2.e();
        state.e = securityParameters.getMasterSecret();
        state.d = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(o2.getCrypto().adoptSecret(state.e)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.i).build();
        state.c = TlsUtils.importSession(securityParameters.getSessionID(), state.d);
        securityParameters.B = securityParameters.getLocalVerifyData();
        o2.a(tlsClient, state.c);
        recordLayer.a(state.q, 1 == state.r);
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState state, DigitallySigned certificateVerify) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateVerify.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState state) throws IOException {
        boolean bl;
        TlsClient tlsClient = state.a;
        o o2 = state.b;
        SecurityParameters securityParameters = o2.getSecurityParametersHandshake();
        ProtocolVersion[] protocolVersionArray = tlsClient.getProtocolVersions();
        ProtocolVersion protocolVersion = ProtocolVersion.getEarliestDTLS(protocolVersionArray);
        ProtocolVersion protocolVersion2 = ProtocolVersion.getLatestDTLS(protocolVersionArray);
        if (!ProtocolVersion.a(protocolVersion2)) {
            throw new TlsFatalAlert(80);
        }
        o2.a(protocolVersion2);
        o2.a(protocolVersionArray);
        boolean bl2 = ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(protocolVersion);
        boolean bl3 = ProtocolVersion.DTLSv13.isEqualOrEarlierVersionOf(protocolVersion2);
        boolean bl4 = !bl3 && tlsClient.shouldUseGMTUnixTime();
        securityParameters.u = TlsProtocol.createRandomBlock(bl4, o2);
        TlsSession tlsSession = bl2 ? tlsClient.getSessionToResume() : null;
        boolean bl5 = tlsClient.isFallback();
        state.g = tlsClient.getCipherSuites();
        state.h = TlsExtensionsUtils.ensureExtensionsInitialised(tlsClient.getClientExtensions());
        boolean bl6 = tlsClient.shouldUseExtendedMasterSecret();
        this.establishSession(state, tlsSession);
        byte[] byArray = TlsUtils.a(state.c);
        if (byArray.length > 0 && !Arrays.contains(state.g, state.d.getCipherSuite())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        ProtocolVersion protocolVersion3 = null;
        if (byArray.length > 0 && !ProtocolVersion.contains(protocolVersionArray, protocolVersion3 = state.d.getNegotiatedVersion())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        if (byArray.length > 0 && TlsUtils.a(protocolVersion3)) {
            if (bl6) {
                if (!state.d.isExtendedMasterSecret() && !tlsClient.allowLegacyResumption()) {
                    byArray = TlsUtils.EMPTY_BYTES;
                }
            } else if (state.d.isExtendedMasterSecret()) {
                byArray = TlsUtils.EMPTY_BYTES;
            }
        }
        if (byArray.length < 1) {
            this.cancelSession(state);
        }
        tlsClient.notifySessionToResume(state.c);
        ProtocolVersion protocolVersion4 = protocolVersion2;
        if (bl3) {
            protocolVersion4 = ProtocolVersion.DTLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(state.h, protocolVersionArray);
        }
        o2.b(protocolVersion4);
        securityParameters.J = TlsExtensionsUtils.getServerNameExtensionClient(state.h);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion2)) {
            TlsUtils.a(securityParameters, state.h);
        }
        securityParameters.M = TlsExtensionsUtils.getSupportedGroupsExtension(state.h);
        state.l = null;
        state.k = TlsUtils.a((TlsClientContext)o2, tlsClient, state.h);
        if (bl6 && TlsUtils.a(protocolVersionArray)) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(state.h);
        } else {
            state.h.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        int n2 = null == TlsUtils.getExtensionData(state.h, TlsProtocol.EXT_RenegotiationInfo) ? 1 : 0;
        boolean bl7 = bl = !Arrays.contains(state.g, 255);
        if (n2 != 0 && bl) {
            state.g = Arrays.append(state.g, 255);
        }
        if (bl5 && !Arrays.contains(state.g, 22016)) {
            state.g = Arrays.append(state.g, 22016);
        }
        state.q = tlsClient.getHeartbeat();
        state.r = tlsClient.getHeartbeatPolicy();
        if (null != state.q || 1 == state.r) {
            TlsExtensionsUtils.addHeartbeatExtension(state.h, new HeartbeatExtension(state.r));
        }
        n2 = null == state.l ? 0 : state.l.d;
        ClientHello clientHello = new ClientHello(protocolVersion4, securityParameters.getClientRandom(), byArray, TlsUtils.EMPTY_BYTES, state.g, state.h, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHello.encode(o2, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState state) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        state.m.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void cancelSession(ClientHandshakeState state) {
        if (state.e != null) {
            state.e.destroy();
            state.e = null;
        }
        if (state.d != null) {
            state.d.clear();
            state.d = null;
        }
        state.c = null;
    }

    protected boolean establishSession(ClientHandshakeState state, TlsSession sessionToResume) {
        state.c = null;
        state.d = null;
        state.e = null;
        if (null == sessionToResume || !sessionToResume.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = sessionToResume.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion protocolVersion = sessionParameters.getNegotiatedVersion();
        if (null == protocolVersion || !protocolVersion.isDTLS()) {
            return false;
        }
        boolean bl = sessionParameters.isExtendedMasterSecret();
        if (!TlsUtils.a(protocolVersion) && !bl) {
            return false;
        }
        TlsCrypto tlsCrypto = state.b.getCrypto();
        TlsSecret tlsSecret = TlsUtils.a(tlsCrypto, sessionParameters.getMasterSecret());
        if (null == tlsSecret) {
            return false;
        }
        state.c = sessionToResume;
        state.d = sessionParameters;
        state.e = tlsSecret;
        return true;
    }

    protected void invalidateSession(ClientHandshakeState state) {
        if (state.c != null) {
            state.c.invalidate();
        }
        this.cancelSession(state);
    }

    protected void processCertificateRequest(ClientHandshakeState state, byte[] body) throws IOException {
        if (null == state.n) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        CertificateRequest certificateRequest = CertificateRequest.parse(state.b, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.p = TlsUtils.a(certificateRequest, state.m);
    }

    protected void processCertificateStatus(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.o = CertificateStatus.parse(state.b, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        int n2 = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) ? 255 : 32;
        byte[] byArray = TlsUtils.readOpaque8(byteArrayInputStream, 0, n2);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(state.b.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        return byArray;
    }

    protected void processNewSessionTicket(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.a.notifyNewSessionTicket(newSessionTicket);
    }

    protected void processServerCertificate(ClientHandshakeState state, byte[] body) throws IOException {
        state.n = TlsUtils.a((TlsClientContext)state.b, state.a, new ByteArrayInputStream(body), state.i);
    }

    protected void processServerHello(ClientHandshakeState state, byte[] body) throws IOException {
        Object object;
        Object object2;
        byte[] byArray;
        byte[] byArray2;
        ProtocolVersion protocolVersion;
        TlsClient tlsClient = state.a;
        o o2 = state.b;
        SecurityParameters securityParameters = o2.getSecurityParametersHandshake();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ServerHello serverHello = ServerHello.parse(byteArrayInputStream);
        Hashtable hashtable = serverHello.getExtensions();
        ProtocolVersion protocolVersion2 = serverHello.getVersion();
        ProtocolVersion protocolVersion3 = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == protocolVersion3) {
            protocolVersion = protocolVersion2;
        } else {
            if (!ProtocolVersion.DTLSv12.equals(protocolVersion2) || !ProtocolVersion.DTLSv13.isEqualOrEarlierVersionOf(protocolVersion3)) {
                throw new TlsFatalAlert(47);
            }
            protocolVersion = protocolVersion3;
        }
        this.reportServerVersion(state, protocolVersion);
        int[] nArray = state.g;
        securityParameters.v = serverHello.getRandom();
        if (!o2.getClientVersion().equals(protocolVersion)) {
            TlsUtils.a(protocolVersion, securityParameters.getServerRandom());
        }
        byte[] byArray3 = serverHello.getSessionID();
        securityParameters.x = byArray3;
        tlsClient.notifySessionID(byArray3);
        boolean bl = securityParameters.b = byArray3.length > 0 && state.c != null && Arrays.areEqual(byArray3, state.c.getSessionID());
        if (securityParameters.isResumedSession() && (serverHello.getCipherSuite() != state.d.getCipherSuite() || !securityParameters.getNegotiatedVersion().equals(state.d.getNegotiatedVersion()))) {
            throw new TlsFatalAlert(47, "ServerHello parameters do not match resumed session");
        }
        int n2 = DTLSClientProtocol.validateSelectedCipherSuite(serverHello.getCipherSuite(), (short)47);
        if (!TlsUtils.a(nArray, n2) || !TlsUtils.isValidVersionForCipherSuite(n2, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47, "ServerHello selected invalid cipher suite");
        }
        TlsUtils.b(securityParameters, n2);
        tlsClient.notifySelectedCipherSuite(n2);
        state.i = hashtable;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                if (n3.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(state.h, n3)) {
                    throw new TlsFatalAlert(110);
                }
                if (!securityParameters.isResumedSession()) continue;
            }
        }
        if ((byArray2 = TlsUtils.getExtensionData(hashtable, TlsProtocol.EXT_RenegotiationInfo)) == null) {
            securityParameters.d = false;
        } else {
            securityParameters.d = true;
            if (!Arrays.constantTimeAreEqual(byArray2, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl2 = false;
        if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(state.h)) {
            bl2 = TlsExtensionsUtils.hasExtendedMasterSecretExtension(hashtable);
            if (TlsUtils.a(protocolVersion)) {
                if (!bl2 && tlsClient.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
            } else if (bl2) {
                throw new TlsFatalAlert(47, "Server sent an unexpected extended_master_secret extension negotiating " + protocolVersion);
            }
        }
        securityParameters.D = bl2;
        if (securityParameters.isResumedSession() && securityParameters.isExtendedMasterSecret() != state.d.isExtendedMasterSecret()) {
            throw new TlsFatalAlert(40, "Server resumed session with mismatched extended_master_secret negotiation");
        }
        securityParameters.G = TlsExtensionsUtils.getALPNExtensionServer(hashtable);
        securityParameters.H = true;
        if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion()) && (byArray = TlsExtensionsUtils.getConnectionIDExtension(hashtable)) != null) {
            object2 = TlsExtensionsUtils.getConnectionIDExtension(state.h);
            if (object2 == null) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.Z = byArray;
            securityParameters.aa = object2;
        }
        if (null == (object = TlsExtensionsUtils.getHeartbeatExtension(hashtable))) {
            state.q = null;
            state.r = (short)2;
        } else if (1 != ((HeartbeatExtension)object).getMode()) {
            state.q = null;
        }
        object = state.h;
        object2 = hashtable;
        if (securityParameters.isResumedSession()) {
            object = null;
            object2 = state.d.readServerExtensions();
        }
        if (object2 != null && !object2.isEmpty()) {
            boolean bl3 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)object2);
            if (bl3 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.C = bl3;
            securityParameters.f = TlsUtils.a((Hashtable)object, (Hashtable)object2, (short)47);
            securityParameters.F = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)object2);
            if (!securityParameters.isResumedSession()) {
                if (TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object2, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.U = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object2, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.U = 1;
                }
                securityParameters.V = TlsUtils.b((Hashtable)object, (Hashtable)object2, (short)47);
                securityParameters.W = TlsUtils.d((Hashtable)object, (Hashtable)object2, (short)47);
                state.j = TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object2, TlsProtocol.EXT_SessionTicket, (short)47);
            }
        }
        if (object != null) {
            tlsClient.processServerExtensions((Hashtable)object2);
        }
    }

    protected void processServerKeyExchange(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.m.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        state.a.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState state, ProtocolVersion server_version) throws IOException {
        o o2 = state.b;
        SecurityParameters securityParameters = o2.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (null != protocolVersion) {
            if (!protocolVersion.equals(server_version)) {
                throw new TlsFatalAlert(47);
            }
            return;
        }
        if (!ProtocolVersion.contains(o2.getClientSupportedVersions(), server_version)) {
            throw new TlsFatalAlert(70);
        }
        securityParameters.T = server_version;
        TlsUtils.b(o2, state.a);
    }

    protected static byte[] patchClientHelloWithCookie(byte[] clientHelloBody, byte[] cookie) throws IOException {
        int n2 = 34;
        short s2 = TlsUtils.readUint8(clientHelloBody, n2);
        int n3 = n2 + 1 + s2;
        int n4 = n3 + 1;
        byte[] byArray = new byte[clientHelloBody.length + cookie.length];
        System.arraycopy(clientHelloBody, 0, byArray, 0, n3);
        TlsUtils.checkUint8(cookie.length);
        TlsUtils.writeUint8(cookie.length, byArray, n3);
        System.arraycopy(cookie, 0, byArray, n4, cookie.length);
        System.arraycopy(clientHelloBody, n4, byArray, n4 + cookie.length, clientHelloBody.length - n4);
        return byArray;
    }

    protected static class ClientHandshakeState {
        TlsClient a = null;
        o b = null;
        TlsSession c = null;
        SessionParameters d = null;
        TlsSecret e = null;
        SessionParameters.Builder f = null;
        int[] g = null;
        Hashtable h = null;
        Hashtable i = null;
        boolean j = false;
        Hashtable k = null;
        OfferedPsks.a l = null;
        TlsKeyExchange m = null;
        TlsAuthentication n = null;
        CertificateStatus o = null;
        CertificateRequest p = null;
        TlsHeartbeat q = null;
        short r = (short)2;

        protected ClientHandshakeState() {
        }
    }
}

