/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.TlsECConfigVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import java.util.Vector;

public class DefaultTlsECConfigVerifier
implements TlsECConfigVerifier {
    protected int minimumCurveBits;
    protected Vector namedGroups;

    public DefaultTlsECConfigVerifier(int minimumCurveBits, Vector namedGroups) {
        this.minimumCurveBits = Math.max(1, minimumCurveBits);
        this.namedGroups = namedGroups;
    }

    @Override
    public boolean accept(TlsECConfig ecConfig) {
        int n2 = ecConfig.getNamedGroup();
        if (n2 < 0) {
            return false;
        }
        if (NamedGroup.getCurveBits(n2) < this.minimumCurveBits) {
            return false;
        }
        return this.namedGroups == null || this.namedGroups.contains(n2);
    }
}

