/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KeyShareEntry {
    protected final int namedGroup;
    protected final byte[] keyExchange;

    private static boolean a(int n2) {
        return 0 < n2 && n2 < 65536;
    }

    public KeyShareEntry(int namedGroup, byte[] keyExchange) {
        if (!TlsUtils.isValidUint16(namedGroup)) {
            throw new IllegalArgumentException("'namedGroup' should be a uint16");
        }
        if (null == keyExchange) {
            throw new NullPointerException("'keyExchange' cannot be null");
        }
        if (!KeyShareEntry.a(keyExchange.length)) {
            throw new IllegalArgumentException("'keyExchange' must have length from 1 to (2^16 - 1)");
        }
        this.namedGroup = namedGroup;
        this.keyExchange = keyExchange;
    }

    public int getNamedGroup() {
        return this.namedGroup;
    }

    public byte[] getKeyExchange() {
        return this.keyExchange;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint16(this.getNamedGroup(), output);
        TlsUtils.writeOpaque16(this.getKeyExchange(), output);
    }

    public static KeyShareEntry parse(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        byte[] byArray = TlsUtils.readOpaque16(input, 1);
        return new KeyShareEntry(n2, byArray);
    }
}

