/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Strings;
import java.util.Vector;

public final class ProtocolVersion {
    public static final ProtocolVersion SSLv3 = new ProtocolVersion(768, "SSL 3.0");
    public static final ProtocolVersion TLSv10 = new ProtocolVersion(769, "TLS 1.0");
    public static final ProtocolVersion TLSv11 = new ProtocolVersion(770, "TLS 1.1");
    public static final ProtocolVersion TLSv12 = new ProtocolVersion(771, "TLS 1.2");
    public static final ProtocolVersion TLSv13 = new ProtocolVersion(772, "TLS 1.3");
    public static final ProtocolVersion DTLSv10 = new ProtocolVersion(65279, "DTLS 1.0");
    public static final ProtocolVersion DTLSv12 = new ProtocolVersion(65277, "DTLS 1.2");
    public static final ProtocolVersion DTLSv13 = new ProtocolVersion(65276, "DTLS 1.3");
    static final ProtocolVersion a = DTLSv10;
    static final ProtocolVersion b = SSLv3;
    static final ProtocolVersion c = DTLSv12;
    static final ProtocolVersion d = TLSv13;
    static final ProtocolVersion e = DTLSv10;
    static final ProtocolVersion f = SSLv3;
    static final ProtocolVersion g = DTLSv12;
    static final ProtocolVersion h = TLSv13;
    private int i;
    private String j;

    public static boolean contains(ProtocolVersion[] versions, ProtocolVersion version) {
        if (versions != null && version != null) {
            for (int i2 = 0; i2 < versions.length; ++i2) {
                if (!version.equals(versions[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public static ProtocolVersion getEarliestDTLS(ProtocolVersion[] versions) {
        ProtocolVersion protocolVersion = null;
        if (null != versions) {
            for (int i2 = 0; i2 < versions.length; ++i2) {
                ProtocolVersion protocolVersion2 = versions[i2];
                if (null == protocolVersion2 || !protocolVersion2.isDTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() <= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    public static ProtocolVersion getEarliestTLS(ProtocolVersion[] versions) {
        ProtocolVersion protocolVersion = null;
        if (null != versions) {
            for (int i2 = 0; i2 < versions.length; ++i2) {
                ProtocolVersion protocolVersion2 = versions[i2];
                if (null == protocolVersion2 || !protocolVersion2.isTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() >= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    public static ProtocolVersion getLatestDTLS(ProtocolVersion[] versions) {
        ProtocolVersion protocolVersion = null;
        if (null != versions) {
            for (int i2 = 0; i2 < versions.length; ++i2) {
                ProtocolVersion protocolVersion2 = versions[i2];
                if (null == protocolVersion2 || !protocolVersion2.isDTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() >= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    public static ProtocolVersion getLatestTLS(ProtocolVersion[] versions) {
        ProtocolVersion protocolVersion = null;
        if (null != versions) {
            for (int i2 = 0; i2 < versions.length; ++i2) {
                ProtocolVersion protocolVersion2 = versions[i2];
                if (null == protocolVersion2 || !protocolVersion2.isTLS() || null != protocolVersion && protocolVersion2.getMinorVersion() <= protocolVersion.getMinorVersion()) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    static boolean a(ProtocolVersion protocolVersion) {
        return null != protocolVersion && protocolVersion.isEqualOrLaterVersionOf(a) && protocolVersion.isEqualOrEarlierVersionOf(c);
    }

    static boolean b(ProtocolVersion protocolVersion) {
        return null != protocolVersion && protocolVersion.isEqualOrLaterVersionOf(e) && protocolVersion.isEqualOrEarlierVersionOf(g);
    }

    static boolean c(ProtocolVersion protocolVersion) {
        if (null == protocolVersion) {
            return false;
        }
        int n2 = protocolVersion.getFullVersion();
        return n2 >= b.getFullVersion() && n2 <= d.getFullVersion();
    }

    static boolean d(ProtocolVersion protocolVersion) {
        if (null == protocolVersion) {
            return false;
        }
        int n2 = protocolVersion.getFullVersion();
        return n2 >= f.getFullVersion() && n2 <= h.getFullVersion();
    }

    private ProtocolVersion(int v2, String name) {
        this.i = v2 & 0xFFFF;
        this.j = name;
    }

    public ProtocolVersion[] downTo(ProtocolVersion min) {
        if (!this.isEqualOrLaterVersionOf(min)) {
            throw new IllegalArgumentException("'min' must be an equal or earlier version of this one");
        }
        Vector<ProtocolVersion> vector = new Vector<ProtocolVersion>();
        vector.addElement(this);
        ProtocolVersion protocolVersion = this;
        while (!protocolVersion.equals(min)) {
            protocolVersion = protocolVersion.getPreviousVersion();
            vector.addElement(protocolVersion);
        }
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            protocolVersionArray[i2] = (ProtocolVersion)vector.elementAt(i2);
        }
        return protocolVersionArray;
    }

    public int getFullVersion() {
        return this.i;
    }

    public int getMajorVersion() {
        return this.i >> 8;
    }

    public int getMinorVersion() {
        return this.i & 0xFF;
    }

    public String getName() {
        return this.j;
    }

    public boolean isDTLS() {
        return this.getMajorVersion() == 254;
    }

    public boolean isSSL() {
        return this == SSLv3;
    }

    public boolean isTLS() {
        return this.getMajorVersion() == 3;
    }

    public ProtocolVersion getEquivalentTLSVersion() {
        switch (this.getMajorVersion()) {
            case 3: {
                return this;
            }
            case 254: {
                switch (this.getMinorVersion()) {
                    case 255: {
                        return TLSv11;
                    }
                    case 253: {
                        return TLSv12;
                    }
                    case 252: {
                        return TLSv13;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public ProtocolVersion getNextVersion() {
        int n2 = this.getMajorVersion();
        int n3 = this.getMinorVersion();
        switch (n2) {
            case 3: {
                switch (n3) {
                    case 255: {
                        return null;
                    }
                }
                return ProtocolVersion.get(n2, n3 + 1);
            }
            case 254: {
                switch (n3) {
                    case 0: {
                        return null;
                    }
                    case 255: {
                        return DTLSv12;
                    }
                }
                return ProtocolVersion.get(n2, n3 - 1);
            }
        }
        return null;
    }

    public ProtocolVersion getPreviousVersion() {
        int n2 = this.getMajorVersion();
        int n3 = this.getMinorVersion();
        switch (n2) {
            case 3: {
                switch (n3) {
                    case 0: {
                        return null;
                    }
                }
                return ProtocolVersion.get(n2, n3 - 1);
            }
            case 254: {
                switch (n3) {
                    case 255: {
                        return null;
                    }
                    case 253: {
                        return DTLSv10;
                    }
                }
                return ProtocolVersion.get(n2, n3 + 1);
            }
        }
        return null;
    }

    public boolean isEarlierVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int n2 = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? n2 > 0 : n2 < 0;
    }

    public boolean isEqualOrEarlierVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int n2 = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? n2 >= 0 : n2 <= 0;
    }

    public boolean isEqualOrLaterVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int n2 = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? n2 <= 0 : n2 >= 0;
    }

    public boolean isLaterVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int n2 = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? n2 < 0 : n2 > 0;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ProtocolVersion && this.equals((ProtocolVersion)other);
    }

    public boolean equals(ProtocolVersion other) {
        return other != null && this.i == other.i;
    }

    public int hashCode() {
        return this.i;
    }

    public static ProtocolVersion get(int major, int minor) {
        switch (major) {
            case 3: {
                switch (minor) {
                    case 0: {
                        return SSLv3;
                    }
                    case 1: {
                        return TLSv10;
                    }
                    case 2: {
                        return TLSv11;
                    }
                    case 3: {
                        return TLSv12;
                    }
                    case 4: {
                        return TLSv13;
                    }
                }
                return ProtocolVersion.a(major, minor, "TLS");
            }
            case 254: {
                switch (minor) {
                    case 255: {
                        return DTLSv10;
                    }
                    case 254: {
                        throw new IllegalArgumentException("{0xFE, 0xFE} is a reserved protocol version");
                    }
                    case 253: {
                        return DTLSv12;
                    }
                    case 252: {
                        return DTLSv13;
                    }
                }
                return ProtocolVersion.a(major, minor, "DTLS");
            }
        }
        return ProtocolVersion.a(major, minor, "UNKNOWN");
    }

    public ProtocolVersion[] only() {
        return new ProtocolVersion[]{this};
    }

    public String toString() {
        return this.j;
    }

    private static void a(int n2) {
        if (!TlsUtils.isValidUint8(n2)) {
            throw new IllegalArgumentException("'versionOctet' is not a valid octet");
        }
    }

    private static ProtocolVersion a(int n2, int n3, String string) {
        ProtocolVersion.a(n2);
        ProtocolVersion.a(n3);
        int n4 = n2 << 8 | n3;
        String string2 = Strings.toUpperCase(Integer.toHexString(0x10000 | n4).substring(1));
        return new ProtocolVersion(n4, string + " 0x" + string2);
    }
}

