/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.HashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SignatureAndHashAlgorithm {
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP256r1tls13_sha256 = SignatureAndHashAlgorithm.a(2074);
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP384r1tls13_sha384 = SignatureAndHashAlgorithm.a(2075);
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP512r1tls13_sha512 = SignatureAndHashAlgorithm.a(2076);
    public static final SignatureAndHashAlgorithm ed25519 = SignatureAndHashAlgorithm.a(2055);
    public static final SignatureAndHashAlgorithm ed448 = SignatureAndHashAlgorithm.a(2056);
    public static final SignatureAndHashAlgorithm gostr34102012_256 = SignatureAndHashAlgorithm.a((short)8, (short)64);
    public static final SignatureAndHashAlgorithm gostr34102012_512 = SignatureAndHashAlgorithm.a((short)8, (short)65);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha256 = SignatureAndHashAlgorithm.a(2052);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha384 = SignatureAndHashAlgorithm.a(2053);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha512 = SignatureAndHashAlgorithm.a(2054);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha256 = SignatureAndHashAlgorithm.a(2057);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha384 = SignatureAndHashAlgorithm.a(2058);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha512 = SignatureAndHashAlgorithm.a(2059);
    protected final short hash;
    protected final short signature;

    public static SignatureAndHashAlgorithm getInstance(short hashAlgorithm, short signatureAlgorithm) {
        switch (hashAlgorithm) {
            case 8: {
                return SignatureAndHashAlgorithm.a(signatureAlgorithm);
            }
        }
        return SignatureAndHashAlgorithm.a(hashAlgorithm, signatureAlgorithm);
    }

    private static SignatureAndHashAlgorithm a(short s2) {
        switch (s2) {
            case 7: {
                return ed25519;
            }
            case 8: {
                return ed448;
            }
            case 64: {
                return gostr34102012_256;
            }
            case 65: {
                return gostr34102012_512;
            }
            case 4: {
                return rsa_pss_rsae_sha256;
            }
            case 5: {
                return rsa_pss_rsae_sha384;
            }
            case 6: {
                return rsa_pss_rsae_sha512;
            }
            case 9: {
                return rsa_pss_pss_sha256;
            }
            case 10: {
                return rsa_pss_pss_sha384;
            }
            case 11: {
                return rsa_pss_pss_sha512;
            }
            case 26: {
                return ecdsa_brainpoolP256r1tls13_sha256;
            }
            case 27: {
                return ecdsa_brainpoolP384r1tls13_sha384;
            }
            case 28: {
                return ecdsa_brainpoolP512r1tls13_sha512;
            }
        }
        return SignatureAndHashAlgorithm.a((short)8, s2);
    }

    private static SignatureAndHashAlgorithm a(int n2) {
        short s2 = SignatureScheme.getHashAlgorithm(n2);
        short s3 = SignatureScheme.getSignatureAlgorithm(n2);
        return SignatureAndHashAlgorithm.a(s2, s3);
    }

    private static SignatureAndHashAlgorithm a(short s2, short s3) {
        return new SignatureAndHashAlgorithm(s2, s3);
    }

    public SignatureAndHashAlgorithm(short hash, short signature) {
        if ((hash & 0xFF) != hash) {
            throw new IllegalArgumentException("'hash' should be a uint8");
        }
        if ((signature & 0xFF) != signature) {
            throw new IllegalArgumentException("'signature' should be a uint8");
        }
        this.hash = hash;
        this.signature = signature;
    }

    public short getHash() {
        return this.hash;
    }

    public short getSignature() {
        return this.signature;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.getHash(), output);
        TlsUtils.writeUint8(this.getSignature(), output);
    }

    public static SignatureAndHashAlgorithm parse(InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        short s3 = TlsUtils.readUint8(input);
        return SignatureAndHashAlgorithm.getInstance(s2, s3);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SignatureAndHashAlgorithm)) {
            return false;
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)obj;
        return signatureAndHashAlgorithm.getHash() == this.getHash() && signatureAndHashAlgorithm.getSignature() == this.getSignature();
    }

    public int hashCode() {
        return this.getHash() << 16 | this.getSignature();
    }

    public String toString() {
        return "{" + HashAlgorithm.getText(this.hash) + "," + SignatureAlgorithm.getText(this.signature) + "}";
    }
}

