/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedAgreement;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsECDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate ecdhPeerCertificate;

    private static int a(int n2) {
        switch (n2) {
            case 16: 
            case 18: {
                return n2;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHKeyExchange(int keyExchange) {
        super(TlsECDHKeyExchange.a(keyExchange));
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.a(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.ecdhPeerCertificate = serverCertificate.getCertificateAt(0).checkUsageInRole(2);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{66, 65};
    }

    @Override
    public void skipClientCredentials() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.a(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        this.ecdhPeerCertificate = clientCertificate.getCertificateAt(0).checkUsageInRole(2);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
    }

    @Override
    public boolean requiresCertificateVerify() {
        return false;
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreementCredentials.generateAgreement(this.ecdhPeerCertificate);
    }
}

