/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class URLAndHash {
    protected String url;
    protected byte[] sha1Hash;

    public URLAndHash(String url, byte[] sha1Hash) {
        if (TlsUtils.isNullOrEmpty(url) || url.length() >= 65536) {
            throw new IllegalArgumentException("'url' must have length from 1 to (2^16 - 1)");
        }
        if (sha1Hash != null && sha1Hash.length != 20) {
            throw new IllegalArgumentException("'sha1Hash' must have length == 20, if present");
        }
        this.url = url;
        this.sha1Hash = sha1Hash;
    }

    public String getURL() {
        return this.url;
    }

    public byte[] getSHA1Hash() {
        return this.sha1Hash;
    }

    public void encode(OutputStream output) throws IOException {
        byte[] byArray = Strings.toByteArray(this.url);
        TlsUtils.writeOpaque16(byArray, output);
        if (this.sha1Hash == null) {
            TlsUtils.writeUint8(0, output);
        } else {
            TlsUtils.writeUint8(1, output);
            output.write(this.sha1Hash);
        }
    }

    public static URLAndHash parse(TlsContext context, InputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(input, 1);
        String string = Strings.fromByteArray(byArray);
        byte[] byArray2 = null;
        short s2 = TlsUtils.readUint8(input);
        switch (s2) {
            case 0: {
                if (!TlsUtils.isTLSv12(context)) break;
                throw new TlsFatalAlert(47);
            }
            case 1: {
                byArray2 = TlsUtils.readFully(20, input);
                break;
            }
            default: {
                throw new TlsFatalAlert(47);
            }
        }
        return new URLAndHash(string, byArray2);
    }
}

