/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.crypto.TlsEncryptor;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected static byte[] copyData(AbstractTlsSecret other) {
        return other.a();
    }

    protected AbstractTlsSecret(byte[] data) {
        this.data = data;
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    @Override
    public synchronized byte[] calculateHMAC(int cryptoHashAlgorithm, byte[] buf, int off, int len) {
        this.checkAlive();
        TlsHMAC tlsHMAC = this.getCrypto().createHMACForHash(cryptoHashAlgorithm);
        tlsHMAC.setKey(this.data, 0, this.data.length);
        tlsHMAC.update(buf, off, len);
        return tlsHMAC.calculateMAC();
    }

    @Override
    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill(this.data, (byte)0);
            this.data = null;
        }
    }

    @Override
    public synchronized byte[] encrypt(TlsEncryptor encryptor) throws IOException {
        this.checkAlive();
        return encryptor.encrypt(this.data, 0, this.data.length);
    }

    @Override
    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] byArray = this.data;
        this.data = null;
        return byArray;
    }

    @Override
    public synchronized boolean isAlive() {
        return null != this.data;
    }

    synchronized byte[] a() {
        return Arrays.clone(this.data);
    }
}

