/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.engines.ChaCha7539Engine;
import com.enterprisedt.bouncycastle.crypto.macs.Poly1305;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;

public class BcChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final byte[] a = new byte[15];
    protected final ChaCha7539Engine cipher = new ChaCha7539Engine();
    protected final Poly1305 mac = new Poly1305();
    protected final boolean isEncrypting;

    public BcChaCha20Poly1305(boolean isEncrypting) {
        this.isEncrypting = isEncrypting;
    }

    @Override
    public int doFinal(byte[] additionalData, byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        boolean bl;
        int n2 = 0;
        if (!Arrays.isNullOrEmpty(additionalData)) {
            n2 = additionalData.length;
            this.updateMAC(additionalData, 0, additionalData.length);
        }
        if (this.isEncrypting) {
            int n3 = inputLength;
            int n4 = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
            if (n3 != n4) {
                throw new IllegalStateException();
            }
            this.updateMAC(output, outputOffset, n3);
            byte[] byArray = new byte[16];
            Pack.longToLittleEndian((long)n2 & 0xFFFFFFFFL, byArray, 0);
            Pack.longToLittleEndian((long)n3 & 0xFFFFFFFFL, byArray, 8);
            this.mac.update(byArray, 0, 16);
            this.mac.doFinal(output, outputOffset + n3);
            return n3 + 16;
        }
        int n5 = inputLength - 16;
        this.updateMAC(input, inputOffset, n5);
        byte[] byArray = new byte[16];
        Pack.longToLittleEndian((long)n2 & 0xFFFFFFFFL, byArray, 0);
        Pack.longToLittleEndian((long)n5 & 0xFFFFFFFFL, byArray, 8);
        this.mac.update(byArray, 0, 16);
        this.mac.doFinal(byArray, 0);
        boolean bl2 = bl = !TlsUtils.constantTimeAreEqual(16, byArray, 0, input, inputOffset + n5);
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        int n6 = this.cipher.processBytes(input, inputOffset, n5, output, outputOffset);
        if (n5 != n6) {
            throw new IllegalStateException();
        }
        return n5;
    }

    @Override
    public int getOutputSize(int inputLength) {
        return this.isEncrypting ? inputLength + 16 : inputLength - 16;
    }

    @Override
    public void init(byte[] nonce, int macSize) throws IOException {
        if (nonce == null || nonce.length != 12 || macSize != 16) {
            throw new TlsFatalAlert(80);
        }
        this.cipher.init(this.isEncrypting, new ParametersWithIV(null, nonce));
        this.initMAC();
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) throws IOException {
        KeyParameter keyParameter = new KeyParameter(key, keyOff, keyLen);
        this.cipher.init(this.isEncrypting, new ParametersWithIV(keyParameter, a, 0, 12));
    }

    protected void initMAC() {
        byte[] byArray = new byte[64];
        this.cipher.processBytes(byArray, 0, 64, byArray, 0);
        this.mac.init(new KeyParameter(byArray, 0, 32));
        Arrays.fill(byArray, (byte)0);
    }

    protected void updateMAC(byte[] buf, int off, int len) {
        this.mac.update(buf, off, len);
        int n2 = len % 16;
        if (n2 != 0) {
            this.mac.update(a, 0, 16 - n2);
        }
    }
}

