/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.DefaultTlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDSA13Signer;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Signer;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Signer;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSSigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static BcTlsCertificate a(BcTlsCrypto bcTlsCrypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return BcTlsCertificate.convert(bcTlsCrypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner a(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner bcTlsSigner;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters;
            int n2;
            RSAKeyParameters rSAKeyParameters2 = (RSAKeyParameters)asymmetricKeyParameter;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(n2 = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsRSAPSSSigner(bcTlsCrypto, rSAKeyParameters2, n2);
            }
            try {
                rSAKeyParameters = BcDefaultTlsCredentialedSigner.a(bcTlsCrypto, certificate).getPubKeyRSA();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            bcTlsSigner = new BcTlsRSASigner(bcTlsCrypto, rSAKeyParameters2, rSAKeyParameters);
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            bcTlsSigner = new BcTlsDSASigner(bcTlsCrypto, (DSAPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            int n3;
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(n3 = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsECDSA13Signer(bcTlsCrypto, eCPrivateKeyParameters, n3);
            }
            bcTlsSigner = new BcTlsECDSASigner(bcTlsCrypto, eCPrivateKeyParameters);
        } else if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
            bcTlsSigner = new BcTlsEd25519Signer(bcTlsCrypto, (Ed25519PrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof Ed448PrivateKeyParameters) {
            bcTlsSigner = new BcTlsEd448Signer(bcTlsCrypto, (Ed448PrivateKeyParameters)asymmetricKeyParameter);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        return bcTlsSigner;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.a(crypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

