/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.engines.RSABlindedEngine;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.PSSSigner;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcTlsRSAPSSSigner
extends BcTlsSigner {
    private final int a;

    public BcTlsRSAPSSSigner(BcTlsCrypto crypto, RSAKeyParameters privateKey, int signatureScheme) {
        super(crypto, privateKey);
        if (!SignatureScheme.isRSAPSS(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.a = signatureScheme;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        if (algorithm == null || SignatureScheme.from(algorithm) != this.a) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int n2 = SignatureScheme.getCryptoHashAlgorithm(this.a);
        Digest digest = this.crypto.createDigest(n2);
        PSSSigner pSSSigner = PSSSigner.createRawSigner((AsymmetricBlockCipher)new RSABlindedEngine(), digest, digest, digest.getDigestSize(), (byte)-68);
        pSSSigner.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        pSSSigner.update(hash, 0, hash.length);
        try {
            return pSSSigner.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
    }
}

