/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.math.ec.rfc7748.X448;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class BcX448
implements TlsAgreement {
    protected final BcTlsCrypto crypto;
    protected final byte[] privateKey = new byte[56];
    protected final byte[] peerPublicKey = new byte[56];

    public BcX448(BcTlsCrypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.crypto.getSecureRandom().nextBytes(this.privateKey);
        byte[] byArray = new byte[56];
        X448.scalarMultBase(this.privateKey, 0, byArray, 0);
        return byArray;
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (peerValue == null || peerValue.length != 56) {
            throw new TlsFatalAlert(47);
        }
        System.arraycopy(peerValue, 0, this.peerPublicKey, 0, 56);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] byArray = new byte[56];
            if (!X448.calculateAgreement(this.privateKey, 0, this.peerPublicKey, 0, byArray, 0)) {
                throw new TlsFatalAlert(40);
            }
            BcTlsSecret bcTlsSecret = this.crypto.a(byArray);
            return bcTlsSecret;
        }
        finally {
            Arrays.fill(this.privateKey, (byte)0);
            Arrays.fill(this.peerPublicKey, (byte)0);
        }
    }
}

