/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import java.util.WeakHashMap;

public final class BigIntegers {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger a = BigInteger.valueOf(3L);
    private static final BigInteger b = new BigInteger("8138e8a0fcf3a4e84a771d40fd305d7f4aa59306d7251de54d98af8fe95729a1f73d893fa424cd2edc8636a6c3285e022b0e3866a565ae8108eed8591cd4fe8d2ce86165a978d719ebf647f362d33fca29cd179fb42401cbaf3df0c614056f9c8f3cfd51e474afb6bc6974f78db8aba8e9e517fded658591ab7502bd41849462f", 16);
    private static final int c = BigInteger.valueOf(743L).bitLength();

    public static byte[] asUnsignedByteArray(BigInteger value) {
        byte[] byArray = value.toByteArray();
        if (byArray[0] == 0 && byArray.length != 1) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] asUnsignedByteArray(int length, BigInteger value) {
        byte[] byArray = value.toByteArray();
        if (byArray.length == length) {
            return byArray;
        }
        int n2 = byArray[0] == 0 && byArray.length != 1 ? 1 : 0;
        int n3 = byArray.length - n2;
        if (n3 > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] byArray2 = new byte[length];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return byArray2;
    }

    public static void asUnsignedByteArray(BigInteger value, byte[] buf, int off, int len) {
        byte[] byArray = value.toByteArray();
        if (byArray.length == len) {
            System.arraycopy(byArray, 0, buf, off, len);
            return;
        }
        int n2 = byArray[0] == 0 && byArray.length != 1 ? 1 : 0;
        int n3 = byArray.length - n2;
        if (n3 > len) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        int n4 = len - n3;
        Arrays.fill(buf, off, off + n4, (byte)0);
        System.arraycopy(byArray, n2, buf, off + n4, n3);
    }

    public static BigInteger createRandomInRange(BigInteger min, BigInteger max, SecureRandom random) {
        int n2 = min.compareTo(max);
        if (n2 >= 0) {
            if (n2 > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return min;
        }
        if (min.bitLength() > max.bitLength() / 2) {
            return BigIntegers.createRandomInRange(ZERO, max.subtract(min), random).add(min);
        }
        for (int i2 = 0; i2 < 1000; ++i2) {
            BigInteger bigInteger = BigIntegers.createRandomBigInteger(max.bitLength(), random);
            if (bigInteger.compareTo(min) < 0 || bigInteger.compareTo(max) > 0) continue;
            return bigInteger;
        }
        return BigIntegers.createRandomBigInteger(max.subtract(min).bitLength() - 1, random).add(min);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] byArray = buf;
        if (off != 0 || length != buf.length) {
            byArray = new byte[length];
            System.arraycopy(buf, off, byArray, 0, length);
        }
        return new BigInteger(1, byArray);
    }

    public static byte byteValueExact(BigInteger x) {
        if (x.bitLength() > 7) {
            throw new ArithmeticException("BigInteger out of int range");
        }
        return x.byteValue();
    }

    public static short shortValueExact(BigInteger x) {
        if (x.bitLength() > 15) {
            throw new ArithmeticException("BigInteger out of int range");
        }
        return x.shortValue();
    }

    public static int intValueExact(BigInteger x) {
        if (x.bitLength() > 31) {
            throw new ArithmeticException("BigInteger out of int range");
        }
        return x.intValue();
    }

    public static long longValueExact(BigInteger x) {
        if (x.bitLength() > 63) {
            throw new ArithmeticException("BigInteger out of long range");
        }
        return x.longValue();
    }

    public static BigInteger modOddInverse(BigInteger M, BigInteger X) {
        int n2;
        int[] nArray;
        int[] nArray2;
        int n3;
        int[] nArray3;
        if (!M.testBit(0)) {
            throw new IllegalArgumentException("'M' must be odd");
        }
        if (M.signum() != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (X.signum() < 0 || X.compareTo(M) >= 0) {
            X = X.mod(M);
        }
        if (0 == Mod.modOddInverse(nArray3 = Nat.fromBigInteger(n3 = M.bitLength(), M), nArray2 = Nat.fromBigInteger(n3, X), nArray = Nat.create(n2 = nArray3.length))) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        return Nat.toBigInteger(n2, nArray);
    }

    public static BigInteger modOddInverseVar(BigInteger M, BigInteger X) {
        int n2;
        int[] nArray;
        int[] nArray2;
        if (!M.testBit(0)) {
            throw new IllegalArgumentException("'M' must be odd");
        }
        if (M.signum() != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (M.equals(ONE)) {
            return ZERO;
        }
        if (X.signum() < 0 || X.compareTo(M) >= 0) {
            X = X.mod(M);
        }
        if (X.equals(ONE)) {
            return ONE;
        }
        int n3 = M.bitLength();
        int[] nArray3 = Nat.fromBigInteger(n3, M);
        if (!Mod.modOddInverseVar(nArray3, nArray2 = Nat.fromBigInteger(n3, X), nArray = Nat.create(n2 = nArray3.length))) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        return Nat.toBigInteger(n2, nArray);
    }

    public static int getUnsignedByteLength(BigInteger n2) {
        if (n2.equals(ZERO)) {
            return 1;
        }
        return (n2.bitLength() + 7) / 8;
    }

    public static BigInteger createRandomBigInteger(int bitLength, SecureRandom random) {
        return new BigInteger(1, BigIntegers.a(bitLength, random));
    }

    public static BigInteger createRandomPrime(int bitLength, int certainty, SecureRandom random) {
        BigInteger bigInteger;
        if (bitLength < 2) {
            throw new IllegalArgumentException("bitLength < 2");
        }
        if (bitLength == 2) {
            return random.nextInt() < 0 ? TWO : a;
        }
        do {
            byte[] byArray = BigIntegers.a(bitLength, random);
            int n2 = 8 * byArray.length - bitLength;
            byte by = (byte)(1 << 7 - n2);
            byArray[0] = (byte)(byArray[0] | by);
            int n3 = byArray.length - 1;
            byArray[n3] = (byte)(byArray[n3] | 1);
            bigInteger = new BigInteger(1, byArray);
            if (bitLength <= c) continue;
            while (!bigInteger.gcd(b).equals(ONE)) {
                bigInteger = bigInteger.add(TWO);
            }
        } while (!bigInteger.isProbablePrime(certainty));
        return bigInteger;
    }

    private static byte[] a(int n2, SecureRandom secureRandom) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("bitLength must be at least 1");
        }
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        secureRandom.nextBytes(byArray);
        int n4 = 8 * n3 - n2;
        byArray[0] = (byte)(byArray[0] & (byte)(255 >>> n4));
        return byArray;
    }

    public static class Cache {
        private final Map<BigInteger, Boolean> a = new WeakHashMap<BigInteger, Boolean>();
        private final BigInteger[] b = new BigInteger[8];
        private int c = 0;

        public synchronized void add(BigInteger value) {
            this.a.put(value, Boolean.TRUE);
            this.b[this.c] = value;
            this.c = (this.c + 1) % this.b.length;
        }

        public synchronized boolean contains(BigInteger value) {
            return this.a.containsKey(value);
        }

        public synchronized int size() {
            return this.a.size();
        }

        public synchronized void clear() {
            this.a.clear();
            for (int i2 = 0; i2 != this.b.length; ++i2) {
                this.b[i2] = null;
            }
        }
    }
}

