/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.asn1.encoding;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNAny;
import com.enterprisedt.cryptix.asn1.lang.ASNBitString;
import com.enterprisedt.cryptix.asn1.lang.ASNBoolean;
import com.enterprisedt.cryptix.asn1.lang.ASNInteger;
import com.enterprisedt.cryptix.asn1.lang.ASNNull;
import com.enterprisedt.cryptix.asn1.lang.ASNObjectIdentifier;
import com.enterprisedt.cryptix.asn1.lang.ASNOctetString;
import com.enterprisedt.cryptix.asn1.lang.ASNPrintableString;
import com.enterprisedt.cryptix.asn1.lang.ASNSequence;
import com.enterprisedt.cryptix.asn1.lang.ASNSequenceOf;
import com.enterprisedt.cryptix.asn1.lang.ASNSet;
import com.enterprisedt.cryptix.asn1.lang.ASNSetOf;
import com.enterprisedt.cryptix.asn1.lang.ASNTaggedType;
import com.enterprisedt.cryptix.asn1.lang.ASNTime;
import com.enterprisedt.cryptix.asn1.lang.Parser;
import com.enterprisedt.cryptix.asn1.lang.SimpleNode;
import com.enterprisedt.cryptix.asn1.lang.Tag;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class DER
extends BaseCoder {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("DER") : 0;

    @Override
    public void encode(ASNBoolean obj, OutputStream out) throws IOException {
        boolean bl = (Boolean)obj.getValue();
        out.write(1);
        DER.a(1, out);
        out.write(bl ? 1 : 0);
    }

    @Override
    public void encode(ASNOctetString obj, OutputStream out) throws IOException {
        byte[] byArray = (byte[])obj.getValue();
        out.write(4);
        DER.a(byArray.length, out);
        out.write(byArray);
    }

    @Override
    public void encode(ASNNull obj, OutputStream out) throws IOException {
        out.write(5);
        DER.a(0, out);
    }

    @Override
    public void encode(ASNObjectIdentifier obj, OutputStream out) throws IOException {
        String string = (String)obj.getValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringTokenizer.nextToken());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(nArray[0] * 40 + nArray[1]);
        for (int i3 = 2; i3 < nArray.length; ++i3) {
            int n2;
            int n3 = nArray[i3];
            byte[] byArray = new byte[4];
            for (n2 = 0; n2 < 4; ++n2) {
                byArray[n2] = (byte)(n3 & 0x7F);
                if ((n3 >>>= 7) == 0) break;
            }
            while (n2 > 0) {
                byteArrayOutputStream.write(byArray[n2] | 0x80);
                --n2;
            }
            byteArrayOutputStream.write(byArray[0]);
        }
        out.write(6);
        DER.a(byteArrayOutputStream.size(), out);
        byteArrayOutputStream.writeTo(out);
    }

    @Override
    public void encode(ASNSequence obj, OutputStream out) throws IOException {
        obj.getValue();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        out.write(16);
        DER.a(byteArrayOutputStream.size(), out);
        byteArrayOutputStream.writeTo(out);
    }

    @Override
    public void encode(ASNTaggedType obj, OutputStream out) throws IOException {
    }

    @Override
    public void encode(ASNTime obj, OutputStream out) throws IOException {
    }

    @Override
    public void decode(ASNBoolean obj, InputStream in) throws IOException {
        if (!this.a(1, in)) {
            String string = "Not a BOOLEAN";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(in);
            if (n2 != 1) {
                throw new IOException("Incorrect BOOLEAN length: " + n2);
            }
            int n3 = in.read();
            if (n3 == -1) {
                throw new EOFException();
            }
            obj.setValue(new Boolean(n3 != 0));
        }
    }

    @Override
    public void decode(ASNInteger obj, InputStream in) throws IOException {
        if (!this.a(2, in)) {
            String string = "Not an INTEGER";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(in);
            byte[] byArray = new byte[n2];
            int n3 = in.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            obj.setValue(new BigInteger(1, byArray));
        }
    }

    @Override
    public void decode(ASNBitString obj, InputStream in) throws IOException {
        if (!this.a(3, in)) {
            String string = "Not a BIT STRING";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(in);
            byte[] byArray = new byte[n2];
            int n3 = in.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            obj.setValue(byArray);
            if (a && b > 8) {
                Debug.log("DER - OUT: " + Hex.toString(byArray));
            }
        }
    }

    @Override
    public void decode(ASNOctetString obj, InputStream in) throws IOException {
        if (!this.a(4, in)) {
            String string = "Not an OCTET STRING";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(in);
            byte[] byArray = new byte[n2];
            int n3 = in.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            obj.setValue(byArray);
            if (a && b > 8) {
                Debug.log("DER - OUT: " + Hex.toString(byArray));
            }
        }
    }

    @Override
    public void decode(ASNNull obj, InputStream in) throws IOException {
        if (!this.a(5, in)) {
            String string = "Not a NULL";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(in);
            if (n2 != 0) {
                throw new IOException("Incorrect NULL length: " + n2);
            }
        }
    }

    @Override
    public void decode(ASNObjectIdentifier obj, InputStream in) throws IOException {
        if (!this.a(6, in)) {
            String string = "Not an OBJECT-IDENTIFIER";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2;
            int n3;
            int n4 = DER.a(in);
            StringBuffer stringBuffer = new StringBuffer();
            if (--n4 >= 0) {
                n3 = in.read() & 0xFF;
                n2 = n3 < 40 ? 0 : (n3 < 80 ? 1 : 2);
                int n5 = n3 - n2 * 40;
                stringBuffer.append(n2).append(".").append(n5);
            }
            while (n4 > 0) {
                stringBuffer.append(".");
                n3 = 0;
                do {
                    n2 = in.read() & 0xFF;
                    n3 = n3 << 7 | n2 & 0x7F;
                } while (--n4 > 0 && (n2 & 0x80) == 128);
                stringBuffer.append(n3);
            }
            obj.setValue(new String(stringBuffer));
        }
    }

    @Override
    public void decode(ASNSequence obj, InputStream in) throws IOException {
        this.a(obj, in);
    }

    @Override
    public void decode(ASNSequenceOf obj, InputStream in) throws IOException {
        this.a(obj, in);
    }

    @Override
    public void decode(ASNSet obj, InputStream in) throws IOException {
        this.b(obj, in);
    }

    @Override
    public void decode(ASNSetOf obj, InputStream in) throws IOException {
        this.b(obj, in);
    }

    @Override
    public void decode(ASNTaggedType obj, InputStream in) throws IOException {
        Tag tag = obj.getTag();
        in.mark(10);
        if (this.a(tag, in)) {
            if (tag.isExplicit()) {
                this.decodeExplicitTaggedType(obj, in);
            } else {
                in.reset();
                this.decodeImplicitTaggedType(obj, in);
            }
        } else {
            Object object;
            String string = "Failed to read a non-optional element";
            if (a && b > 0) {
                Debug.log("DER - " + string);
            }
            if ((object = obj.getDefaultValue()) == null && !obj.isOptional()) {
                throw new IOException(string);
            }
            if (object != null) {
                obj.setValue(object);
            }
            in.reset();
        }
    }

    @Override
    public void decode(ASNAny obj, InputStream in) throws IOException {
        byte[] byArray = this.b(in);
        if (byArray != null) {
            obj.setValue(byArray);
        }
        if (a && b > 8) {
            Debug.log("DER - OUT: " + Hex.toString(byArray));
        }
    }

    @Override
    public void decode(ASNPrintableString obj, InputStream in) throws IOException {
        boolean bl = false;
        if (!(this.a(19, in) || this.a(12, in) || this.a(22, in) || (bl = this.a(30, in)))) {
            String string = "Not a PrintableString or IA5String or UTF8String or UNICODEString";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(in);
            byte[] byArray = new byte[n2];
            int n3 = in.read(byArray);
            if (n2 != 0 && n3 == -1) {
                throw new EOFException();
            }
            if (n2 != 0 && n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            if (bl) {
                obj.setValue(new String(byArray, "UTF-16"));
            } else {
                obj.setValue(new String(byArray, "UTF-8"));
            }
        }
    }

    @Override
    public void decode(ASNTime obj, InputStream in) throws IOException {
        if (!this.a(23, in) && !this.a(24, in)) {
            String string = "Not a UTC_TIME or GENERALIZED_TIME";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!obj.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(in);
            byte[] byArray = new byte[n2];
            int n3 = in.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            int n4 = (byArray[0] - 48) * 10 + (byArray[1] - 48);
            int n5 = (byArray[2] - 48) * 10 + (byArray[3] - 48) - 1;
            int n6 = (byArray[4] - 48) * 10 + (byArray[5] - 48);
            int n7 = (byArray[6] - 48) * 10 + (byArray[7] - 48);
            int n8 = (byArray[8] - 48) * 10 + (byArray[9] - 48);
            int n9 = 0;
            n4 += n4 <= 50 ? 2000 : 1900;
            if (byArray[10] != 90) {
                n9 = (byArray[10] - 48) * 10 + (byArray[11] - 48);
                if (byArray.length == 15 && byArray[14] != 90) {
                    throw new IOException("Bad date format");
                }
                if (byArray.length == 13 && byArray[12] != 90) {
                    throw new IOException("Bad date format");
                }
            }
            calendar.set(n4, n5, n6, n7, n8, n9);
            obj.setValue(calendar.getTime());
        }
    }

    private boolean a(int n2, InputStream inputStream) throws IOException {
        Tag tag = Tag.getExpectedTag(n2, inputStream);
        return tag != null;
    }

    private boolean a(Tag tag, InputStream inputStream) throws IOException {
        Tag tag2 = Tag.getExpectedTag(tag, inputStream);
        return tag2 != null;
    }

    private static int a(InputStream inputStream) throws IOException {
        int n2;
        int n3 = inputStream.read();
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) > 4) {
                throw new IOException("ASN.1 DER object too large");
            }
            n2 = 0;
            while (n3-- > 0) {
                n2 = n2 << 8 | inputStream.read() & 0xFF;
            }
        }
        if (a && b > 7) {
            Debug.log("DER - Element length = " + n2);
        }
        return n2;
    }

    private void a(SimpleNode simpleNode, InputStream inputStream) throws IOException {
        if (!this.a(16, inputStream) && !this.a(48, inputStream)) {
            String string = "Not a SEQUENCE [OF]";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!simpleNode.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            Vector<Object> vector = new Vector<Object>();
            while (byteArrayInputStream.available() != 0) {
                Object object = simpleNode.childrenAccept(coderOperations, null);
                if (object == null) continue;
                vector.addElement(object);
            }
            simpleNode.setValue(vector);
        }
    }

    private void b(SimpleNode simpleNode, InputStream inputStream) throws IOException {
        if (!this.a(17, inputStream) && !this.a(49, inputStream)) {
            String string = "Not a SET [OF]";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            if (!simpleNode.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.a(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            Vector<Object> vector = new Vector<Object>();
            while (byteArrayInputStream.available() != 0) {
                Object object = simpleNode.childrenAccept(coderOperations, null);
                vector.addElement(object);
            }
            simpleNode.setValue(vector);
        }
    }

    public void decodeExplicitTaggedType(ASNTaggedType obj, InputStream in) throws IOException {
        int n2 = DER.a(in);
        byte[] byArray = new byte[n2];
        int n3 = in.read(byArray);
        if (n3 == -1) {
            throw new EOFException();
        }
        if (n3 != n2) {
            throw new IOException("Length (" + n2 + ") mismatch: " + n3);
        }
        CoderOperations coderOperations = BaseCoder.getInstance("DER");
        coderOperations.init(new ByteArrayInputStream(byArray));
        SimpleNode simpleNode = (SimpleNode)Parser.resolve(obj.getName());
        Object object = simpleNode.childrenAccept(coderOperations, null);
        String string = "********************* New value: XXX";
        if (a && b > 0) {
            Debug.log("DER - " + string);
        }
        obj.setValue(object);
    }

    public boolean decodeImplicitTaggedType(ASNTaggedType obj, InputStream in) throws IOException {
        byte[] byArray = Tag.getTag(in);
        Tag tag = obj.getTag();
        if (tag.isExplicit()) {
            return false;
        }
        int n2 = DER.a(in);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (obj.jjtGetNumChildren() != 1) {
            String string = "Implicitly Tagged types must have exactly one child";
            if (a && b > 8) {
                Debug.log("DER - " + string);
            }
            throw new IOException(string);
        }
        Tag tag2 = obj.getChild(0).getTag();
        if (tag2 == null) {
            if (a && b > 0) {
                Debug.log("DER - ... decoding an IMPLICIT ANY, using original tag");
            }
            byteArrayOutputStream.write(byArray);
        } else {
            byteArrayOutputStream.write(tag2.getValue());
        }
        DER.a(n2, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = new byte[n2 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        int n3 = in.read(byArray3, byArray2.length, n2);
        if (n3 == -1) {
            throw new EOFException();
        }
        if (n3 != n2) {
            throw new IOException("Length (" + n2 + ") mismatch: " + n3);
        }
        CoderOperations coderOperations = BaseCoder.getInstance("DER");
        coderOperations.init(new ByteArrayInputStream(byArray3));
        Object object = obj.childrenAccept(coderOperations, null);
        obj.setValue(object);
        return true;
    }

    public void decode(InputStream in, int level) throws IOException {
        byte[] byArray;
        int n2;
        Tag tag;
        Vector<a> vector = new Vector<a>();
        while (in.available() != 0) {
            try {
                tag = Tag.decode(in);
                n2 = DER.a(in);
                byArray = new byte[n2];
                in.read(byArray);
                vector.addElement(new a(tag, n2, byArray));
            }
            catch (EOFException eOFException) {
                Debug.log("DER - " + eOFException.toString());
                break;
            }
        }
        if (a && b > 8) {
            int n3;
            String string = "\t";
            for (n3 = 0; n3 < level; ++n3) {
                string = string + "+--";
            }
            ++level;
            for (n3 = 0; n3 < vector.size(); ++n3) {
                a a2 = (a)vector.elementAt(n3);
                tag = a2.a();
                n2 = a2.b();
                byArray = a2.c();
                System.out.println(string + "Tag: " + tag + "; Length: " + n2);
                if (!tag.isConstructed()) continue;
                this.decode(new ByteArrayInputStream(byArray), level);
            }
        }
    }

    private static void a(int n2, OutputStream outputStream) throws IOException {
        if (n2 < 128) {
            outputStream.write((byte)n2);
            return;
        }
        if (n2 < 256) {
            outputStream.write(-127);
            outputStream.write((byte)n2);
            return;
        }
        if (n2 < 65536) {
            outputStream.write(-126);
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)n2);
            return;
        }
        if (n2 < 0x1000000) {
            outputStream.write(-125);
            outputStream.write((byte)(n2 >> 16));
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)n2);
            return;
        }
        outputStream.write(-124);
        outputStream.write((byte)(n2 >> 24));
        outputStream.write((byte)(n2 >> 16));
        outputStream.write((byte)(n2 >> 8));
        outputStream.write((byte)n2);
    }

    private byte[] b(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = Tag.getTag(inputStream);
        if (byArray == null) {
            return null;
        }
        if (a && b > 0) {
            Debug.log("DER - Tag: " + Hex.toString(byArray));
        }
        int n2 = DER.a(inputStream);
        byteArrayOutputStream.write(byArray);
        DER.a(n2, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = new byte[byArray2.length + n2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        if (n2 > 0) {
            int n3 = inputStream.read(byArray3, byArray2.length, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
        }
        return byArray3;
    }

    class a {
        Tag a;
        int b;
        byte[] c;

        a(Tag tag, int n2, byte[] byArray) {
            this.a = tag;
            this.b = n2;
            this.c = (byte[])byArray.clone();
        }

        Tag a() {
            return this.a;
        }

        int b() {
            return this.b;
        }

        byte[] c() {
            return (byte[])this.c.clone();
        }
    }
}

