/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mode;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.mode.a;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class OFB
extends a {
    public OFB() {
        super(true, false, "CryptixEDT");
    }

    public OFB(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public OFB(Cipher cipher, byte[] iv) {
        this(cipher);
        this.setInitializationVector(iv);
    }

    @Override
    protected int engineBlockSize() {
        return 1;
    }

    @Override
    protected void engineInitEncrypt(Key newkey) throws KeyException {
        this.cipher.initEncrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    @Override
    protected void engineInitDecrypt(Key newkey) throws KeyException {
        this.cipher.initEncrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("OFB: IV is not set");
        }
        if (this.getState() == 0) {
            throw new CryptixException("OFB: Cipher not initialized");
        }
        if (in == out && outOffset > inOffset && (long)outOffset < (long)inOffset + (long)inLen) {
            byte[] byArray = new byte[inLen];
            System.arraycopy(in, inOffset, byArray, 0, inLen);
            in = byArray;
            inOffset = 0;
        }
        for (int i2 = 0; i2 < inLen; ++i2) {
            out[i2 + outOffset] = this.a(in[i2 + inOffset]);
        }
        return inLen;
    }

    private byte a(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            this.cipher.update(this.ivBlock, 0, this.length, this.ivBlock, 0);
        }
        by = (byte)(by ^ this.ivBlock[this.currentByte]);
        ++this.currentByte;
        return by;
    }
}

